/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.misc;

import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.generic.XIModifier;
import com.xiaoyue.tinkers_ingenuity.utils.entity.EntityUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ThousandHeavy
extends XIModifier
implements BlockBreakModifierHook,
ModifierRemovalHook {
    private final ResourceLocation KEY = TinkersIngenuity.location("thousand_heavy");

    @Override
    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, ModifierHooks.BLOCK_BREAK, ModifierHooks.REMOVE);
    }

    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(this.KEY);
        return null;
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        tool.getPersistentData().putInt(this.KEY, tool.getPersistentData().getInt(this.KEY) + 1);
    }

    @Override
    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity entity, int index, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ModDataNBT toolData = tool.getPersistentData();
            if (isCorrectSlot && toolData.getInt(this.KEY) == 10 + modifier.getLevel()) {
                toolData.putInt(this.KEY, 0);
                EntityUtils.addEffect((LivingEntity)player, MobEffects.f_19599_, 1200, 5);
            }
        }
    }
}

