/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.misc;

import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.generic.XIRModifier;
import com.xiaoyue.tinkers_ingenuity.utils.item.TooltipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class SoulDevouring
extends XIRModifier
implements ModifierRemovalHook {
    private final ResourceLocation KEY = TinkersIngenuity.location("soul_devouring");

    @Override
    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, ModifierHooks.REMOVE);
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        this.getData(tool).remove(this.KEY);
        return null;
    }

    private float getBonus(IToolStackView tool, int level) {
        return this.getData(tool).getFloat(this.KEY) * 0.1f * (float)level;
    }

    @Override
    public float onModifyMeleeDamage(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float baseDamage, float actualDamage) {
        if (this.getData(tool).contains(this.KEY, 5)) {
            return actualDamage * (1.0f + this.getBonus(tool, level));
        }
        return actualDamage;
    }

    @Override
    public void onTinkerArrowShoot(IToolStackView bow, int level, LivingEntity shooter, Projectile projectile, AbstractArrow arrow, NamespacedNBT namespacedNBT, boolean primary) {
        if (this.getData(bow).contains(this.KEY, 5)) {
            arrow.m_36781_(arrow.m_36789_() * (double)(1.0f + this.getBonus(bow, level)));
        }
    }

    @Override
    public void onKillTarget(IToolStackView tool, LivingDeathEvent event, LivingEntity attacker, LivingEntity target, int level) {
        if (event.getSource().m_7640_() instanceof AbstractArrow) {
            this.getData(tool).putFloat(this.KEY, this.getData(tool).getFloat(this.KEY) + 0.1f * (float)level);
        }
    }

    @Override
    public void onAfterMeleeHit(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float damageDealt) {
        if (target.m_21224_()) {
            this.getData(tool).putFloat(this.KEY, this.getData(tool).getFloat(this.KEY) + 0.1f * (float)level);
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> list, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player != null && this.getData(tool).contains(this.KEY, 5)) {
            TooltipModifierHook.addPercentBoost((Modifier)this, (Component)TooltipUtils.addTooltip("soul_devouring.attack_damage"), (double)(this.getData(tool).getFloat(this.KEY) * 0.1f), list);
        }
    }
}

