/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.misc;

import com.xiaoyue.tinkers_ingenuity.generic.XIRModifier;
import com.xiaoyue.tinkers_ingenuity.utils.entity.EntityUtils;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class Rippling
extends XIRModifier {
    @Override
    public void onAfterMeleeHit(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float damageDealt) {
        boolean critical = context.isCritical();
        if (!critical) {
            int effectLevel = Math.min(3 + level, EntityUtils.getEffectLevel(attacker, MobEffects.f_19596_));
            EntityUtils.addEffect(attacker, MobEffects.f_19596_, 100, effectLevel + 1);
        }
    }

    @Override
    public float onModifyMeleeDamage(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float baseDamage, float actualDamage) {
        int effectLevel = EntityUtils.getEffectLevel(attacker, MobEffects.f_19596_);
        if (effectLevel > 0) {
            return actualDamage + (float)(effectLevel * level);
        }
        return actualDamage;
    }

    @Override
    public void onArrowHitTarget(ModifierNBT modifiers, NamespacedNBT persistentData, int level, Projectile projectile, AbstractArrow arrow, EntityHitResult hit, LivingEntity attacker, LivingEntity target) {
        int effectLevel = Math.min(3 + level, EntityUtils.getEffectLevel(attacker, MobEffects.f_19596_));
        EntityUtils.addEffect(attacker, MobEffects.f_19596_, 100, effectLevel + 1);
        if (effectLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)(effectLevel * level));
        }
    }
}

