/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.misc;

import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.generic.XIRModifier;
import com.xiaoyue.tinkers_ingenuity.register.TIEffects;
import com.xiaoyue.tinkers_ingenuity.utils.entity.EntityUtils;
import com.xiaoyue.tinkers_ingenuity.utils.item.CooldownUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class Firefly
extends XIRModifier
implements GeneralInteractionModifierHook {
    private final ResourceLocation FIREFLY = TinkersIngenuity.location("firefly");

    private int getFirefly(IToolStackView tool) {
        return tool.getPersistentData().getInt(this.FIREFLY);
    }

    private void addFirefly(IToolStackView tool) {
        tool.getPersistentData().putInt(this.FIREFLY, this.getFirefly(tool) + 1);
    }

    private void removeFirefly(IToolStackView tool) {
        tool.getPersistentData().putInt(this.FIREFLY, 0);
    }

    @Override
    public boolean isSingleLevel() {
        return true;
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, ModifierHooks.GENERAL_INTERACT);
    }

    @Override
    public void onTakeDamage(IToolStackView tool, LivingDamageEvent event, DamageSource source, LivingEntity entity, int level) {
        if (event.getAmount() < entity.m_21223_()) {
            return;
        }
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            if (this.getFirefly(tool) == 3) {
                this.addFirefly(tool);
                EntityUtils.addEffect(entity, MobEffects.f_19600_, 600);
                EntityUtils.addEffect(attacker, MobEffects.f_19613_, 600, 1);
            }
            if (attacker.m_21023_((MobEffect)TIEffects.LAST_STAND.get())) {
                event.setAmount(event.getAmount() * 1.4f);
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!CooldownUtils.notOn((LivingEntity)player, player.m_21205_())) {
                return;
            }
            if (this.getFirefly(tool) != 7) {
                return;
            }
            this.removeFirefly(tool);
            for (LivingEntity list : EntityUtils.getMonsters((LivingEntity)player, 5)) {
                if (!(list instanceof Player)) continue;
                Player playerList = (Player)list;
                playerList.m_5634_(playerList.m_21233_() - playerList.m_21223_());
            }
        }
    }

    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        ItemStack stack;
        if (source == InteractionSource.RIGHT_CLICK && CooldownUtils.notOn((LivingEntity)player, stack = player.m_21120_(hand))) {
            if (!player.m_6047_()) {
                return InteractionResult.PASS;
            }
            if (this.getFirefly(tool) == 7) {
                this.removeFirefly(tool);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    private void modifierEffect(IToolStackView tool, boolean isCritical, LivingEntity attacker) {
        if (isCritical) {
            if (this.getFirefly(tool) == 2) {
                this.addFirefly(tool);
                EntityUtils.addEffect(attacker, MobEffects.f_19606_, 1200);
            }
            if (this.getFirefly(tool) == 4) {
                this.addFirefly(tool);
                attacker.m_21220_().removeIf(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
                attacker.m_7911_(attacker.m_6103_() + 6.0f);
            }
            if (this.getFirefly(tool) == 6) {
                this.addFirefly(tool);
                for (LivingEntity list : EntityUtils.getExceptForCenterMonsters(attacker, 5)) {
                    if (!(list.m_21233_() > attacker.m_21233_())) continue;
                    list.m_6469_(DamageSource.m_19370_((LivingEntity)attacker), list.m_21233_() * 0.25f);
                }
            }
        } else {
            if (this.getFirefly(tool) == 0) {
                this.addFirefly(tool);
            }
            if (this.getFirefly(tool) == 1) {
                this.addFirefly(tool);
                attacker.m_5634_((attacker.m_21233_() - attacker.m_21223_()) * 0.4f);
            }
            if (this.getFirefly(tool) == 5) {
                this.addFirefly(tool);
                EntityUtils.addEffect(attacker, (MobEffect)TIEffects.LAST_STAND.get(), 100);
            }
        }
    }

    @Override
    public void onAfterMeleeHit(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float damageDealt) {
        this.modifierEffect(tool, context.isCritical(), attacker);
    }

    @Override
    public void onTinkerArrowShoot(IToolStackView bow, int level, LivingEntity shooter, Projectile projectile, AbstractArrow arrow, NamespacedNBT namespacedNBT, boolean primary) {
        this.modifierEffect(bow, arrow.m_36792_(), shooter);
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> list, TooltipKey key, TooltipFlag tooltipFlag) {
        if (this.getFirefly(tool) != 0) {
            list.add((Component)Component.m_237115_((String)("tooltip.tinkers_ingenuity.firefly.effect" + this.getFirefly(tool))));
        }
    }
}

