/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.misc;

import com.xiaoyue.tinkers_ingenuity.generic.XIRModifier;
import com.xiaoyue.tinkers_ingenuity.register.TIEffects;
import com.xiaoyue.tinkers_ingenuity.utils.entity.EntityUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class Feverish
extends XIRModifier {
    @Override
    public boolean isSingleLevel() {
        return true;
    }

    @Override
    public void onAfterMeleeHit(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float damageDealt) {
        if (context.isFullyCharged()) {
            int effectLevel = EntityUtils.getEffectLevel(attacker, (MobEffect)TIEffects.MALIGNANT.get());
            EntityUtils.addEffect(attacker, (MobEffect)TIEffects.MALIGNANT.get(), 80, effectLevel + 1);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, FloatToolStat stat, float baseValue, float multiplier) {
        int effectLevel = EntityUtils.getEffectLevel(entity, (MobEffect)TIEffects.MALIGNANT.get());
        if (effectLevel > 0 && stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.0f + 0.02f * (float)effectLevel);
        }
        return baseValue;
    }

    @Override
    public void onArrowHitTarget(ModifierNBT modifiers, NamespacedNBT persistentData, int level, Projectile projectile, AbstractArrow arrow, EntityHitResult hit, LivingEntity attacker, LivingEntity target) {
        int effectLevel = EntityUtils.getEffectLevel(attacker, (MobEffect)TIEffects.MALIGNANT.get());
        EntityUtils.addEffect(attacker, (MobEffect)TIEffects.MALIGNANT.get(), 80, effectLevel + 1);
    }
}

