/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.both;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArmorAttackContext;
import com.xiaoyue.tinkers_ingenuity.generic.XIModifier;
import com.xiaoyue.tinkers_ingenuity.register.TIEffects;
import com.xiaoyue.tinkers_ingenuity.utils.entity.EntityUtils;
import com.xiaoyue.tinkers_ingenuity.utils.item.CooldownUtils;
import com.xiaoyue.tinkers_ingenuity.utils.item.ToolUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class DivineGraceOde
extends XIModifier {
    @Override
    public boolean isSingleLevel() {
        return true;
    }

    @Override
    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity entity, int index, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        Player player;
        if (isCorrectSlot && entity instanceof Player && (player = (Player)entity).m_21223_() < player.m_21233_() * 0.5f && CooldownUtils.notOn((LivingEntity)player, stack)) {
            EntityUtils.addEffect((LivingEntity)player, MobEffects.f_19605_, 40, 1);
        }
    }

    private void ModifierEffect(LivingEntity entity, DamageSource source, ToolStack toolStack, IToolStackView tool) {
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            ToolDamageUtil.directDamage((IToolStackView)tool, (int)500, (LivingEntity)entity, (ItemStack)toolStack.createStack());
            EntityUtils.addEffect(attacker, (MobEffect)TIEffects.FRAGILE.get(), 2, 2400);
            EntityUtils.spawnThunder((Entity)attacker);
            CooldownUtils.add(entity, toolStack, 3600);
        }
    }

    @Override
    public void onTakeDamage(IToolStackView armor, LivingDamageEvent event, ArmorAttackContext context, int level) {
        LivingEntity entity = context.target();
        ToolStack toolStack = ToolUtils.getNotBrokenAndCooldownArmor(entity);
        if (toolStack == null || event.isCanceled()) {
            return;
        }
        if (event.getAmount() > entity.m_21223_() && CooldownUtils.notOn(entity, toolStack) && !entity.m_21023_((MobEffect)TIEffects.LAST_STAND.get())) {
            event.setCanceled(true);
            this.ModifierEffect(entity, event.getSource(), toolStack, armor);
        }
    }

    @Override
    public void onTakeDamage(IToolStackView tool, LivingDamageEvent event, DamageSource source, LivingEntity entity, int level) {
        ToolStack toolStack = ToolUtils.getNotBrokenToolInHand(entity);
        if (toolStack == null || event.isCanceled()) {
            return;
        }
        if (event.getAmount() > entity.m_21223_() && CooldownUtils.notOn(entity, toolStack) && !entity.m_21023_((MobEffect)TIEffects.LAST_STAND.get())) {
            event.setCanceled(true);
            this.ModifierEffect(entity, source, toolStack, tool);
        }
    }
}

