/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.mixin;

import com.xiaoyue.tinkers_ingenuity.content.library.events.AttackCooldownEvent;
import com.xiaoyue.tinkers_ingenuity.utils.entity.EntityUtils;
import com.xiaoyue.tinkers_ingenuity.utils.item.ToolUtils;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Unique
    private Player tinkersIngenuity$getPlayer() {
        return (Player)this;
    }

    @Unique
    private float tinkersIngenuity$getAttackCooldown(Player player) {
        return (float)(1.0 / EntityUtils.getAttackSpeed(player) * 20.0);
    }

    @Inject(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="HEAD")}, cancellable=true)
    public void tinkersIngenuity$getAttackStrengthDelay(CallbackInfoReturnable<Float> cir) {
        Player player = this.tinkersIngenuity$getPlayer();
        AttackCooldownEvent event = new AttackCooldownEvent(player, EntityUtils.getAttackSpeed(player), this.tinkersIngenuity$getAttackCooldown(player));
        cir.setReturnValue((Object)Float.valueOf(ToolUtils.Hooks.fireEvent(event).getAttackCooldown()));
    }
}

