/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.generic.Interface.curio;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArrowImpactContext;
import com.xiaoyue.tinkers_ingenuity.content.library.context.CurioAttributeContext;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import top.theillusivec4.curios.api.SlotContext;

public interface TinkerCurioHook {
    public static final TinkerCurioHook EMPTY = new TinkerCurioHook(){};

    default public void onCurioTick(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack) {
    }

    default public void addCurioAttribute(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack, CurioAttributeContext attr) {
    }

    default public void onCurioEquip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack prevStack, ItemStack stack) {
    }

    default public void onCurioUnequip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack newStack, ItemStack stack) {
    }

    default public void onCurioTakeHeal(IToolStackView curio, LivingHealEvent event, LivingEntity entity, int level) {
    }

    default public void onCurioShootArrow(IToolStackView curio, LivingEntity shooter, AbstractArrow arrow, int level) {
    }

    default public void onCurioArrowHit(IToolStackView curio, LivingEntity shooter, ArrowImpactContext context, int level) {
    }

    default public void onCurioBreakSpeed(IToolStackView curio, PlayerEvent.BreakSpeed event, Player player, int level) {
    }

    public record AllMerger(Collection<TinkerCurioHook> modules) implements TinkerCurioHook
    {
        @Override
        public void onCurioTick(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack) {
            for (TinkerCurioHook module : this.modules) {
                module.onCurioTick(curio, context, entity, level, stack);
            }
        }

        @Override
        public void addCurioAttribute(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack, CurioAttributeContext attr) {
            for (TinkerCurioHook module : this.modules) {
                module.addCurioAttribute(curio, context, entity, level, stack, attr);
            }
        }

        @Override
        public void onCurioEquip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack prevStack, ItemStack stack) {
            for (TinkerCurioHook module : this.modules) {
                module.onCurioEquip(curio, context, entity, level, prevStack, stack);
            }
        }

        @Override
        public void onCurioUnequip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack newStack, ItemStack stack) {
            for (TinkerCurioHook module : this.modules) {
                module.onCurioUnequip(curio, context, entity, level, newStack, stack);
            }
        }

        @Override
        public void onCurioTakeHeal(IToolStackView curio, LivingHealEvent event, LivingEntity entity, int level) {
            for (TinkerCurioHook module : this.modules) {
                module.onCurioTakeHeal(curio, event, entity, level);
            }
        }

        @Override
        public void onCurioShootArrow(IToolStackView curio, LivingEntity shooter, AbstractArrow arrow, int level) {
            for (TinkerCurioHook module : this.modules) {
                module.onCurioShootArrow(curio, shooter, arrow, level);
            }
        }

        @Override
        public void onCurioArrowHit(IToolStackView curio, LivingEntity shooter, ArrowImpactContext context, int level) {
            for (TinkerCurioHook module : this.modules) {
                module.onCurioArrowHit(curio, shooter, context, level);
            }
        }

        @Override
        public void onCurioBreakSpeed(IToolStackView curio, PlayerEvent.BreakSpeed event, Player player, int level) {
            for (TinkerCurioHook module : this.modules) {
                module.onCurioBreakSpeed(curio, event, player, level);
            }
        }
    }
}

