/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.generic.Interface.curio;

import com.xiaoyue.tinkers_ingenuity.content.library.events.LivingCalculateAbsEvent;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface CurioAttackHook {
    public static final CurioAttackHook EMPTY = new CurioAttackHook(){};

    default public void onCurioToHurt(IToolStackView curio, LivingHurtEvent event, LivingEntity attacker, LivingEntity target, int level) {
    }

    default public void onCurioToDamageAbs(IToolStackView curio, LivingCalculateAbsEvent event, LivingEntity attacker, LivingEntity target, int level) {
    }

    default public void onCurioToDamage(IToolStackView curio, LivingDamageEvent event, LivingEntity attacker, LivingEntity target, int level) {
    }

    default public void onCurioTakeHurt(IToolStackView curio, LivingHurtEvent event, LivingEntity entity, DamageSource source, int level) {
    }

    default public void onCurioTakeDamage(IToolStackView curio, LivingDamageEvent event, LivingEntity entity, DamageSource source, int level) {
    }

    public record AllMerger(Collection<CurioAttackHook> modules) implements CurioAttackHook
    {
        @Override
        public void onCurioToHurt(IToolStackView curio, LivingHurtEvent event, LivingEntity attacker, LivingEntity target, int level) {
            for (CurioAttackHook module : this.modules) {
                module.onCurioToHurt(curio, event, attacker, target, level);
            }
        }

        @Override
        public void onCurioToDamageAbs(IToolStackView curio, LivingCalculateAbsEvent event, LivingEntity attacker, LivingEntity target, int level) {
            for (CurioAttackHook module : this.modules) {
                module.onCurioToDamageAbs(curio, event, attacker, target, level);
            }
        }

        @Override
        public void onCurioToDamage(IToolStackView curio, LivingDamageEvent event, LivingEntity attacker, LivingEntity target, int level) {
            for (CurioAttackHook module : this.modules) {
                module.onCurioToDamage(curio, event, attacker, target, level);
            }
        }

        @Override
        public void onCurioTakeHurt(IToolStackView curio, LivingHurtEvent event, LivingEntity entity, DamageSource source, int level) {
            for (CurioAttackHook module : this.modules) {
                module.onCurioTakeHurt(curio, event, entity, source, level);
            }
        }

        @Override
        public void onCurioTakeDamage(IToolStackView curio, LivingDamageEvent event, LivingEntity entity, DamageSource source, int level) {
            for (CurioAttackHook module : this.modules) {
                module.onCurioTakeDamage(curio, event, entity, source, level);
            }
        }
    }
}

