/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.events.hook;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArmorAttackContext;
import com.xiaoyue.tinkers_ingenuity.content.library.events.AttackCooldownEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.events.LivingCalculateAbsEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.events.TinkerToolCriticalEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.IngenuityHooks;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.armor.ArmorMoreHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.armor.ExperienceHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.armor.KnockBackHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.tool.AttackSpeedHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.tool.InteractionHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.tool.ToolMoreHook;
import com.xiaoyue.tinkers_ingenuity.utils.item.ToolUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="tinkers_ingenuity", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TinkerHandler {
    private static void onHurtEntity(LivingHurtEvent event, LivingEntity entity) {
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            EquipmentContext context = new EquipmentContext(attacker);
            if (!context.hasModifiableArmor()) {
                return;
            }
            for (EquipmentSlot slot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                IToolStackView armor = context.getToolInSlot(slot);
                if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
                for (ModifierEntry entry : armor.getModifierList()) {
                    ((ArmorMoreHook)entry.getHook(IngenuityHooks.ARMOR_MORE_HOOK)).onHurtTarget(armor, event, new ArmorAttackContext(event.getSource(), entity, context, slot), entry.getLevel());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        TinkerHandler.onHurtEntity(event, entity);
        EquipmentContext context = new EquipmentContext(entity);
        if (!context.hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slot : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slot);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            for (ModifierEntry entry : armor.getModifierList()) {
                ((ArmorMoreHook)entry.getHook(IngenuityHooks.ARMOR_MORE_HOOK)).onTakeHurt(armor, event, new ArmorAttackContext(event.getSource(), entity, context, slot), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        EquipmentContext context;
        LivingEntity entity = event.getEntity();
        ToolStack tool = ToolUtils.getToolInHand(entity);
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
            for (ModifierEntry entry : tool.getModifierList()) {
                ((ToolMoreHook)entry.getHook(IngenuityHooks.TOOL_MORE_HOOK)).onTakeDamage((IToolStackView)tool, event, event.getSource(), entity, entry.getLevel());
            }
        }
        if (!(context = new EquipmentContext(entity)).hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slotType);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            for (ModifierEntry entry : armor.getModifierList()) {
                ((ArmorMoreHook)entry.getHook(IngenuityHooks.ARMOR_MORE_HOOK)).onTakeDamage(armor, event, new ArmorAttackContext(event.getSource(), entity, context, slotType), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingCalculate(LivingCalculateAbsEvent event) {
        LivingEntity attacker = event.getLivingAttacker();
        if (attacker == null) {
            return;
        }
        ToolStack tool = ToolUtils.getToolInHand(attacker);
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
            for (ModifierEntry entry : tool.getModifierList()) {
                ((ToolMoreHook)entry.getHook(IngenuityHooks.TOOL_MORE_HOOK)).onDamageAbs((IToolStackView)tool, event, attacker, event.getEntity(), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingKill(LivingDeathEvent event) {
        LivingEntity attacker;
        ToolStack tool;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && ToolUtils.isNotBrokenOrNull((IToolStackView)(tool = ToolUtils.getToolInHand(attacker = (LivingEntity)entity)))) {
            for (ModifierEntry entry : tool.getModifierList()) {
                ((ToolMoreHook)entry.getHook(IngenuityHooks.TOOL_MORE_HOOK)).onKillTarget((IToolStackView)tool, event, attacker, event.getEntity(), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onKnockBack(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        EquipmentContext context = new EquipmentContext(entity);
        if (!context.hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slotType);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            for (ModifierEntry entry : armor.getModifierList()) {
                ((KnockBackHook)entry.getHook(IngenuityHooks.KNOCK_BACK_HOOK)).onKnockBack(armor, event, entity, entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        EquipmentContext context = new EquipmentContext(entity);
        if (!context.hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slotType);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            for (ModifierEntry entry : armor.getModifierList()) {
                ((ArmorMoreHook)entry.getHook(IngenuityHooks.ARMOR_MORE_HOOK)).onTakeHeal(armor, event, entity, entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(TinkerToolCriticalEvent event) {
        LivingEntity attacker = event.getContext().getAttacker();
        if (event.getContext().getLivingTarget() == null) {
            return;
        }
        for (ModifierEntry entry : event.getTool().getModifierList()) {
            ((ToolMoreHook)entry.getHook(IngenuityHooks.TOOL_MORE_HOOK)).onCriticalHit(event.getTool(), event, attacker, event.getContext().getLivingTarget(), entry.getLevel());
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_21211_().m_41619_()) {
                return;
            }
            ToolStack toolStack = ToolStack.from((ItemStack)player.m_21211_());
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((ToolMoreHook)entry.getHook(IngenuityHooks.TOOL_MORE_HOOK)).onShieldBlocked((IToolStackView)toolStack, event, player, event.getDamageSource(), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onPickupXp(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        EquipmentContext context = new EquipmentContext((LivingEntity)player);
        if (!context.hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slotType);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            for (ModifierEntry entry : armor.getModifierList()) {
                ((ExperienceHook)entry.getHook(IngenuityHooks.EXPERIENCE_HOOK)).onPickupXp(armor, player, context, slotType, event.getOrb(), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onModifyAttackCooldown(AttackCooldownEvent event) {
        Player player = event.getPlayer();
        ToolStack toolStack = ToolUtils.getToolInHand((LivingEntity)player);
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)toolStack)) {
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((AttackSpeedHook)entry.getHook(IngenuityHooks.ATTACK_SPEED_HOOK)).modifyAttackCooldown((IToolStackView)toolStack, player, event, entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ToolStack toolStack = ToolUtils.getToolStack(event.getItemStack());
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)toolStack)) {
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((InteractionHook)entry.getHook(IngenuityHooks.INTERACTION_HOOK)).onLeftClickEmpty(toolStack, event.getEntity(), event.getHand(), entry.getLevel(), event.getItemStack());
            }
        }
    }
}

