/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.events.hook;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArrowImpactContext;
import com.xiaoyue.tinkers_ingenuity.content.library.events.LivingCalculateAbsEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.IngenuityHooks;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.curio.CurioAttackHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.curio.TinkerCurioHook;
import com.xiaoyue.tinkers_ingenuity.utils.item.ToolUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

@Mod.EventBusSubscriber(modid="tinkers_ingenuity", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CurioHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            if (ToolUtils.Curios.getStacks(attacker).isEmpty()) {
                return;
            }
            for (ItemStack stack : ToolUtils.Curios.getStacks(attacker)) {
                ToolStack toolStack = ToolStack.from((ItemStack)stack);
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    ((CurioAttackHook)entry.getHook(IngenuityHooks.CURIO_ATTACK_HOOK)).onCurioToHurt((IToolStackView)toolStack, event, attacker, entity, entry.getLevel());
                }
            }
        }
        if (ToolUtils.Curios.getStacks(entity).isEmpty()) {
            return;
        }
        for (ItemStack stack : ToolUtils.Curios.getStacks(entity)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((CurioAttackHook)entry.getHook(IngenuityHooks.CURIO_ATTACK_HOOK)).onCurioTakeHurt((IToolStackView)toolStack, event, entity, event.getSource(), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            if (ToolUtils.Curios.getStacks(attacker).isEmpty()) {
                return;
            }
            for (ItemStack stack : ToolUtils.Curios.getStacks(attacker)) {
                ToolStack toolStack = ToolStack.from((ItemStack)stack);
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    ((CurioAttackHook)entry.getHook(IngenuityHooks.CURIO_ATTACK_HOOK)).onCurioToDamage((IToolStackView)toolStack, event, attacker, event.getEntity(), entry.getLevel());
                }
            }
        }
        if (ToolUtils.Curios.getStacks(entity).isEmpty()) {
            return;
        }
        for (ItemStack stack : ToolUtils.Curios.getStacks(entity)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((CurioAttackHook)entry.getHook(IngenuityHooks.CURIO_ATTACK_HOOK)).onCurioTakeDamage((IToolStackView)toolStack, event, entity, event.getSource(), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingCalculate(LivingCalculateAbsEvent event) {
        LivingEntity attacker = event.getLivingAttacker();
        if (attacker == null || ToolUtils.Curios.getStacks(attacker).isEmpty()) {
            return;
        }
        for (ItemStack stack : ToolUtils.Curios.getStacks(attacker)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((CurioAttackHook)entry.getHook(IngenuityHooks.CURIO_ATTACK_HOOK)).onCurioToDamageAbs((IToolStackView)toolStack, event, attacker, event.getEntity(), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (ToolUtils.Curios.getStacks(entity).isEmpty()) {
            return;
        }
        for (ItemStack stack : ToolUtils.Curios.getStacks(entity)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).onCurioTakeHeal((IToolStackView)toolStack, event, entity, entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onShootArrow(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        Entity entity2 = arrow.m_37282_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity3 = (LivingEntity)entity2;
        if (ToolUtils.Curios.getStacks(entity3).isEmpty()) {
            return;
        }
        for (ItemStack stack : ToolUtils.Curios.getStacks(entity3)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            float arrow_damage = ConditionalStatModifierHook.getModifiedStat((IToolStackView)toolStack, (LivingEntity)entity3, (FloatToolStat)ToolStats.PROJECTILE_DAMAGE);
            arrow.m_36781_(arrow.m_36789_() * (double)(1.0f + arrow_damage));
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).onCurioShootArrow((IToolStackView)toolStack, entity3, arrow, entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        Entity entity = arrow.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)entity;
        if (ToolUtils.Curios.getStacks(shooter).isEmpty()) {
            return;
        }
        for (ItemStack stack : ToolUtils.Curios.getStacks(shooter)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).onCurioArrowHit((IToolStackView)toolStack, shooter, new ArrowImpactContext(arrow, event), entry.getLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (ToolUtils.Curios.getStacks((LivingEntity)player).isEmpty()) {
            return;
        }
        for (ItemStack stack : ToolUtils.Curios.getStacks((LivingEntity)player)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            for (ModifierEntry entry : toolStack.getModifierList()) {
                ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).onCurioBreakSpeed((IToolStackView)toolStack, event, player, entry.getLevel());
            }
        }
    }
}

