/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record BatteryMaterialStats(int energyCapacity, float durability) implements IMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId("tinkers_ingenuity", "battery");
    public static final MaterialStatType<BatteryMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new BatteryMaterialStats(0, 0.0f), RecordLoadable.create((RecordField)IntLoadable.FROM_ZERO.defaultField("energy_capacity", (Object)0, true, BatteryMaterialStats::energyCapacity), (RecordField)FloatLoadable.ANY.defaultField("durability", (Object)Float.valueOf(1.0f), true, BatteryMaterialStats::durability), BatteryMaterialStats::new));
    private static final String ENERGY_CAPACITY_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)TinkersIngenuity.location("energy_capacity"));
    private static final String DURABILITY_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)TConstruct.getResource((String)"durability"));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)IMaterialStats.makeTooltip((ResourceLocation)TinkersIngenuity.location("battery.energy_capacity.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)TConstruct.getResource((String)"handle.durability.description")));

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    @NotNull
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @NotNull
    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(IToolStat.formatColoredBonus((String)ENERGY_CAPACITY_PREFIX, (float)this.energyCapacity));
        info.add(IToolStat.formatColoredPercentBoost((String)DURABILITY_PREFIX, (float)this.durability));
        return info;
    }

    @NotNull
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float scale) {
        TIToolStats.ENERGY_STORE.add(builder, (double)this.energyCapacity);
        ToolStats.DURABILITY.percent(builder, (double)this.durability);
    }
}

