/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.xiaoyue.tinkers_ingenuity.content.library.context.CurioAttributeContext;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.IngenuityHooks;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.curio.CurioAddonHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.curio.TinkerCurioHook;
import com.xiaoyue.tinkers_ingenuity.utils.item.StatTipUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TinkerCurio
extends ModifiableItem
implements ICurioItem {
    public TinkerCurio(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        return ImmutableMultimap.of();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    private void getCurioStatAttribute(Multimap<Attribute, AttributeModifier> modifiers, ToolStack tool, UUID uuid) {
        StatsNBT toolStats = tool.getStats();
        modifiers.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "curios_movement_speed_bonus", (double)((Float)toolStats.get((IToolStat)TIToolStats.MOVEMENT_SPEED)).floatValue(), AttributeModifier.Operation.MULTIPLY_BASE));
        modifiers.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "curios_armor_bonus", (double)((Float)toolStats.get((IToolStat)TIToolStats.ARMOR)).floatValue(), AttributeModifier.Operation.MULTIPLY_BASE));
        modifiers.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "curios_armor_toughness_bonus", (double)((Float)toolStats.get((IToolStat)TIToolStats.ARMOR_TOUGHNESS)).floatValue(), AttributeModifier.Operation.MULTIPLY_BASE));
        modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "curios_attack_damage_bonus", (double)((Float)toolStats.get((IToolStat)TIToolStats.ATTACK_DAMAGE)).floatValue(), AttributeModifier.Operation.MULTIPLY_BASE));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ToolStack toolStack = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : toolStack.getModifierList()) {
            ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).onCurioTick((IToolStackView)toolStack, slotContext, slotContext.entity(), entry.getLevel(), stack);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        this.getCurioStatAttribute((Multimap<Attribute, AttributeModifier>)modifiers, tool, uuid);
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).addCurioAttribute((IToolStackView)tool, slotContext, slotContext.entity(), entry.getLevel(), stack, new CurioAttributeContext(uuid, (Multimap<Attribute, AttributeModifier>)modifiers));
        }
        return modifiers;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        ToolStack toolStack = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : toolStack.getModifierList()) {
            ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).onCurioEquip((IToolStackView)toolStack, slotContext, slotContext.entity(), entry.getLevel(), prevStack, stack);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        ToolStack toolStack = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : toolStack.getModifierList()) {
            ((TinkerCurioHook)entry.getHook(IngenuityHooks.TINKER_CURIO_HOOK)).onCurioUnequip((IToolStackView)toolStack, slotContext, slotContext.entity(), entry.getLevel(), newStack, stack);
        }
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        int fortune = super.getFortuneLevel(slotContext, lootContext, stack);
        ToolStack toolStack = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : toolStack.getModifierList()) {
            fortune = ((CurioAddonHook)entry.getHook(IngenuityHooks.CURIO_ADDON_HOOK)).onCurioGetFortune((IToolStackView)toolStack, slotContext, lootContext, stack, fortune, entry.getLevel());
        }
        return fortune;
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack stack) {
        int looting = super.getLootingLevel(slotContext, source, target, baseLooting, stack);
        ToolStack toolStack = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : toolStack.getModifierList()) {
            looting = ((CurioAddonHook)entry.getHook(IngenuityHooks.CURIO_ADDON_HOOK)).onCurioGetLooting((IToolStackView)toolStack, slotContext, source, target, stack, looting, entry.getLevel());
        }
        return looting;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), stack.m_41720_()).isEmpty();
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        return this.getCurioStats(tool, player, tooltips, key, tooltipFlag);
    }

    public List<Component> getCurioStats(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltips);
        StatTipUtils.addPerToolStatTooltip(builder, tool, TIToolStats.MOVEMENT_SPEED);
        StatTipUtils.addPerToolStatTooltip(builder, tool, TIToolStats.ARMOR);
        StatTipUtils.addPerToolStatTooltip(builder, tool, TIToolStats.ARMOR_TOUGHNESS);
        StatTipUtils.addPerToolStatTooltip(builder, tool, TIToolStats.ATTACK_DAMAGE);
        StatTipUtils.addPerToolStatTooltip(builder, tool, TIToolStats.ARROW_DAMAGE);
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TooltipModifierHook)entry.getHook(ModifierHooks.TOOLTIP)).addTooltip(tool, entry, player, tooltips, key, tooltipFlag);
        }
        return tooltips;
    }
}

