/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.tools.item;

import com.xiaoyue.tinkers_ingenuity.content.capability.EnergyCapability;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import com.xiaoyue.tinkers_ingenuity.utils.item.CooldownUtils;
import com.xiaoyue.tinkers_ingenuity.utils.item.StatTipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class LaserGun
extends ModifiableItem {
    public LaserGun(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public void emitLaser(ToolStack toolStack, Player attacker, InteractionHand hand, Level world, Vec3 angle, float range) {
        Vec3 start = attacker.m_146892_();
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (double d = 0.0; d < (double)range; d += 0.5) {
            Vec3 currentPos = start.m_82549_(angle.m_82541_().m_82490_(d));
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175831_, currentPos.m_82507_(Direction.Axis.X), currentPos.m_82507_(Direction.Axis.Y), currentPos.m_82507_(Direction.Axis.Z), 1, 0.0, 0.0, 0.0, 0.0);
            AABB smallAabb = new AABB(currentPos.f_82479_ - 0.5, currentPos.f_82480_ - 0.5, currentPos.f_82481_ - 0.5, currentPos.f_82479_ + 0.5, currentPos.f_82480_ + 0.5, currentPos.f_82481_ + 0.5);
            for (LivingEntity entity : world.m_45976_(LivingEntity.class, smallAabb)) {
                if (!entity.m_6084_() || entities.contains(entity) || entity == attacker) continue;
                ToolAttackUtil.attackEntity((IToolStackView)toolStack, (LivingEntity)attacker, (InteractionHand)hand, (Entity)entity, (DoubleSupplier)ToolAttackUtil.getCooldownFunction((Player)attacker, (InteractionHand)hand), (boolean)false);
                entities.add(entity);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        ToolStack tool = ToolStack.from((ItemStack)itemStack);
        ModDataNBT toolData = tool.getPersistentData();
        boolean creative = player.m_150110_().f_35937_;
        if ((!tool.isBroken() && toolData.contains(EnergyCapability.STORED_ENERGY, 3) || creative) && !level.m_5776_()) {
            boolean hasEnergy;
            boolean bl = hasEnergy = toolData.getInt(EnergyCapability.STORED_ENERGY) >= 500;
            if (!creative && !hasEnergy) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            float range = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TIToolStats.LASER_RANGE);
            float cooldown = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TIToolStats.COOLDOWN, (float)(((Float)tool.getStats().get((IToolStat)TIToolStats.COOLDOWN)).floatValue() * 20.0f));
            this.emitLaser(tool, player, hand, level, player.m_20154_(), range);
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)1, (LivingEntity)player, (InteractionHand)hand);
            EnergyCapability.removeEnergy((IToolStackView)tool, 500, false, false);
            CooldownUtils.add((LivingEntity)player, (Item)this, Math.round(cooldown));
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        tooltips = this.getLaserGunStats(tool, player, tooltips, key, tooltipFlag);
        return tooltips;
    }

    public List<Component> getLaserGunStats(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltips);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.addDurability();
        }
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            builder.add((IToolStat)ToolStats.ATTACK_DAMAGE);
            builder.add((IToolStat)ToolStats.ATTACK_SPEED);
        }
        StatTipUtils.addToolStatTooltip(builder, tool, TIToolStats.LASER_RANGE);
        StatTipUtils.addToolStatTooltip(builder, tool, TIToolStats.COOLDOWN);
        StatTipUtils.addToolStatTooltip(builder, tool, TIToolStats.ENERGY_STORE);
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TooltipModifierHook)entry.getHook(ModifierHooks.TOOLTIP)).addTooltip(tool, entry, player, tooltips, key, tooltipFlag);
        }
        return tooltips;
    }
}

