/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.library.helper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ScheduleHelper {
    private static final List<Cache> tasks = new ArrayList<Cache>();
    private final String id;
    private int currentTick;
    private final int requiredTick;
    private final Runnable action;
    public boolean running;

    public ScheduleHelper(String id, int requiredTick, Runnable action) {
        this.id = id;
        this.currentTick = 0;
        this.requiredTick = requiredTick;
        this.action = action;
    }

    public String getId() {
        return this.id;
    }

    public Runnable getAction() {
        return this.action;
    }

    public int getRequiredTick() {
        return this.requiredTick;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public void setCurrentTick(int currentTick) {
        this.currentTick = currentTick;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Nullable
    public static ScheduleHelper getProxyFromId(String id) {
        if (tasks.isEmpty()) {
            return null;
        }
        for (Cache cache : tasks) {
            if (!cache.proxy.getId().equals(id)) continue;
            return cache.proxy;
        }
        return null;
    }

    public static void serverTick() {
        if (tasks.isEmpty()) {
            return;
        }
        for (Cache cache : tasks) {
            ScheduleHelper proxy = cache.getProxy();
            if (proxy.currentTick >= proxy.requiredTick) {
                proxy.action.run();
                proxy.running = false;
                cache.setUsed(true);
                continue;
            }
            ++proxy.currentTick;
            proxy.running = true;
        }
        tasks.removeIf(Cache::isUsed);
    }

    public static void scheduleInTick(String id, int requiredTick, Runnable action) {
        ScheduleHelper proxy = new ScheduleHelper(id, requiredTick, action);
        tasks.add(new Cache(proxy, false));
    }

    private static class Cache {
        private final ScheduleHelper proxy;
        private boolean used;

        public Cache(ScheduleHelper proxy, boolean used) {
            this.proxy = proxy;
            this.used = used;
        }

        public ScheduleHelper getProxy() {
            return this.proxy;
        }

        public boolean isUsed() {
            return this.used;
        }

        public void setUsed(boolean isUsed) {
            this.used = isUsed;
        }
    }
}

