/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.library.helper;

import java.util.Iterator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.RemoveBlockModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class BreakLogicHelper {
    public static boolean removeBlock(IToolStackView tool, ToolHarvestContext context) {
        Boolean removed = null;
        if (!tool.isBroken()) {
            ModifierEntry entry;
            Iterator iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && (removed = ((RemoveBlockModifierHook)(entry = (ModifierEntry)iterator.next()).getHook(ModifierHooks.REMOVE_BLOCK)).removeBlock(tool, entry, context)) == null) {
            }
        }
        BlockState state = context.getState();
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        if (removed == null) {
            removed = state.onDestroyedByPlayer((Level)world, pos, (Player)context.getPlayer(), context.canHarvest(), world.m_6425_(pos));
        }
        if (removed.booleanValue()) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return removed;
    }

    public static boolean breakBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        ServerPlayer player = Objects.requireNonNull(context.getPlayer());
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        GameType type = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, type)) {
            return false;
        }
        if (player.m_7500_()) {
            BreakLogicHelper.removeBlock((IToolStackView)tool, context);
            return true;
        }
        BlockState state = context.getState();
        int damage = ToolHarvestLogic.getDamage((ToolStack)tool, (Level)world, (BlockPos)pos, (BlockState)state);
        BlockEntity te = world.m_7702_(pos);
        boolean removed = BreakLogicHelper.removeBlock((IToolStackView)tool, context);
        Block block = state.m_60734_();
        if (removed) {
            block.m_6240_((Level)world, (Player)player, pos, state, te, stack);
        }
        if (removed && exp > 0) {
            block.m_49805_(world, pos, exp);
        }
        if (!tool.isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                ((BlockBreakModifierHook)entry.getHook(ModifierHooks.BLOCK_BREAK)).afterBlockBreak((IToolStackView)tool, entry, context);
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)damage, (LivingEntity)player);
        }
        return true;
    }
}

