/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.compat.iceandfire;

import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.xiaoyue.tinkers_ingenuity.content.library.context.ArmorAttackContext;
import com.xiaoyue.tinkers_ingenuity.generic.XIModifier;
import com.xiaoyue.tinkers_ingenuity.utils.entity.EntityUtils;
import com.xiaoyue.tinkers_ingenuity.utils.mod.LoadingUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DragonSteel
extends XIModifier {
    @Override
    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        ToolStats.ARMOR.add(builder, 4.0);
        ToolStats.ARMOR_TOUGHNESS.add(builder, 9.0);
    }

    @Override
    public void onHurtTarget(IToolStackView armor, LivingHurtEvent event, ArmorAttackContext context, int level) {
        Player player;
        Entity entity;
        if (LoadingUtils.isLoadIceAndFire() && (entity = context.getAttacker()) instanceof Player && EntityUtils.isEmptyInHand((LivingEntity)(player = (Player)entity))) {
            event.setAmount(event.getAmount() + 0.75f * (float)level);
        }
    }

    @Override
    public void onTakeHurt(IToolStackView armor, LivingHurtEvent event, ArmorAttackContext context, int level) {
        Entity attacker = context.getAttacker();
        if (LoadingUtils.isLoadIceAndFire() && (attacker instanceof EntityIceDragon || attacker instanceof EntityFireDragon || attacker instanceof EntityLightningDragon)) {
            event.setAmount(event.getAmount() * (1.0f - 0.17f * (float)level));
        }
    }
}

