/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity;

import com.xiaoyue.tinkers_ingenuity.content.capability.EnergyCapability;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIMaterialStats;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import com.xiaoyue.tinkers_ingenuity.content.tools.stats.tier.SeaDream;
import com.xiaoyue.tinkers_ingenuity.network.handler.PacketHandler;
import com.xiaoyue.tinkers_ingenuity.register.TIEffects;
import com.xiaoyue.tinkers_ingenuity.register.TIEntityTypes;
import com.xiaoyue.tinkers_ingenuity.register.TIFluidTypes;
import com.xiaoyue.tinkers_ingenuity.register.TIItems;
import com.xiaoyue.tinkers_ingenuity.register.TIModifiers;
import com.xiaoyue.tinkers_ingenuity.register.data.TinkerRecipes;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="tinkers_ingenuity")
public class TinkersIngenuity {
    public static final String MODID = "tinkers_ingenuity";

    public TinkersIngenuity() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::getCurioSlots);
        TIItems.init(eventBus);
        TIEntityTypes.init(eventBus);
        TIEffects.init(eventBus);
        TIModifiers.init(eventBus);
        TIFluidTypes.init(eventBus);
        TinkerRecipes.init(eventBus);
        TIToolStats.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation location(String id) {
        return new ResourceLocation(MODID, id);
    }

    public static <T> TinkerDataCapability.TinkerDataKey<T> createKey(String name) {
        return TinkerDataCapability.TinkerDataKey.of((ResourceLocation)TinkersIngenuity.location(name));
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        event.enqueueWork(TIMaterialStats::setup);
        ToolCapabilityProvider.register(EnergyCapability::new);
        if (!TierSortingRegistry.isTierSorted((Tier)SeaDream.instance)) {
            if (!TierSortingRegistry.getSortedTiers().isEmpty()) {
                TierSortingRegistry.registerTier((Tier)SeaDream.instance, (ResourceLocation)new ResourceLocation("tinkers_ingenuity:sea_dream"), List.of(TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size() + 2)), List.of());
            } else {
                TierSortingRegistry.registerTier((Tier)SeaDream.instance, (ResourceLocation)new ResourceLocation("tinkers_ingenuity:sea_dream"), List.of(Tiers.NETHERITE), List.of());
            }
        }
    }

    public void getCurioSlots(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().build());
    }
}

