/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.paypur.tconjei.TConJEI;
import me.paypur.tconjei.jei.ToolPartsWrapper;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.tools.TinkerTools;

public class ToolPartsCategory
implements IRecipeCategory<ToolPartsWrapper> {
    static final MutableComponent TITLE = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Tool Recipe"));
    static final RecipeType<ToolPartsWrapper> RECIPE_TYPE = RecipeType.create((String)"tconjei", (String)"tool_parts", ToolPartsWrapper.class);
    static final ResourceLocation UID = new ResourceLocation("tconjei", "tool_parts");
    final IDrawable background;
    final IDrawable icon;
    final IDrawable anvil;
    final IDrawable slot;
    static final int WIDTH = 120;
    static final int HEIGHT = 60;
    static final int ITEM_SIZE = 16;

    public ToolPartsCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/jei.png"), 0, 16, 120, 60);
        this.icon = guiHelper.createDrawableItemStack(((ModifiableItem)TinkerTools.sledgeHammer.get()).getRenderTool());
        this.anvil = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/jei.png"), 222, 0, 16, 16);
        this.slot = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/jei.png"), 238, 0, 18, 18);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ToolPartsWrapper recipe, IFocusGroup focuses) {
        recipe.getInputParts().forEach(parts -> builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(parts));
        List<LayoutSlot> slots = recipe.getSlots();
        List<ItemStack> items = recipe.getDisplayParts();
        assert (items.size() == slots.size());
        Vec2 offsets = this.getOffsets(recipe);
        for (int i = 0; i < items.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)((float)slots.get(i).getX() + offsets.f_82470_), (int)((float)slots.get(i).getY() + offsets.f_82471_)).addItemStack(items.get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 22).addItemStack(recipe.getOutputTool());
    }

    public void draw(ToolPartsWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        if (recipe.isBroadTool()) {
            this.anvil.draw(stack, 65, 42);
        }
        Vec2 offsets = this.getOffsets(recipe);
        for (LayoutSlot slot : recipe.getSlots()) {
            this.slot.draw(stack, (int)((float)slot.getX() + offsets.f_82470_ - 1.0f), (int)((float)slot.getY() + offsets.f_82471_ - 1.0f));
        }
    }

    public List<Component> getTooltipStrings(ToolPartsWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return recipe.isBroadTool() && TConJEI.inBox(mouseX, mouseY, 65.0f, 42.0f, 16.0f, 16.0f) ? Collections.singletonList(MutableComponent.m_237204_((ComponentContents)new LiteralContents("Broad tools require a Tinker's Anvil!"))) : Collections.emptyList();
    }

    private Vec2 getOffsets(ToolPartsWrapper recipe) {
        List<LayoutSlot> slots = recipe.getSlots();
        int minX = slots.get(0).getX();
        int maxX = slots.get(0).getX();
        int minY = slots.get(0).getY();
        int maxY = slots.get(0).getY();
        for (int i = 1; i < slots.size(); ++i) {
            minX = Math.min(slots.get(i).getX(), minX);
            maxX = Math.max(slots.get(i).getX(), maxX);
            minY = Math.min(slots.get(i).getY(), minY);
            maxY = Math.max(slots.get(i).getY(), maxY);
        }
        int yOffset = (60 - (16 + maxY - minY)) / 2 - minY;
        int xOffset = (60 - (16 + maxX - minX)) / 2 - minX;
        return new Vec2((float)xOffset, (float)yOffset);
    }

    @Nonnull
    public Component getTitle() {
        return TITLE;
    }

    @Nonnull
    public RecipeType<ToolPartsWrapper> getRecipeType() {
        return RECIPE_TYPE;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }
}

