/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.paypur.tconjei.jei.ArmorStatsCategory;
import me.paypur.tconjei.jei.HarvestStatsCategory;
import me.paypur.tconjei.jei.RangedStatsCategory;
import me.paypur.tconjei.jei.ToolPartsCategory;
import me.paypur.tconjei.jei.ToolPartsWrapper;
import me.paypur.tconjei.jei.ToolStatsWrapper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

@JeiPlugin
public class TConJEIPlugin
implements IModPlugin {
    ResourceLocation UID = new ResourceLocation("tconjei", "jei_plugin");
    private static final RecipeType<ToolStatsWrapper> HARVEST_STATS = RecipeType.create((String)"tconjei", (String)"harvest_stats", ToolStatsWrapper.class);
    private static final RecipeType<ToolStatsWrapper> RANGED_STATS = RecipeType.create((String)"tconjei", (String)"ranged_stats", ToolStatsWrapper.class);
    private static final RecipeType<ToolStatsWrapper> ARMOR_STATS = RecipeType.create((String)"tconjei", (String)"armor_stats", ToolStatsWrapper.class);
    private static final RecipeType<ToolPartsWrapper> TOOL_PARTS = RecipeType.create((String)"tconjei", (String)"tool_parts", ToolPartsWrapper.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return this.UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<ToolStatsWrapper> statsWrappers = this.materials();
        registration.addRecipes(HARVEST_STATS, statsWrappers.stream().filter(w -> w.hasStats(List.of(HeadMaterialStats.ID, StatlessMaterialStats.BINDING.getIdentifier(), HandleMaterialStats.ID))).toList());
        registration.addRecipes(RANGED_STATS, statsWrappers.stream().filter(w -> w.hasStats(List.of(LimbMaterialStats.ID, GripMaterialStats.ID, StatlessMaterialStats.BOWSTRING.getIdentifier()))).toList());
        registration.addRecipes(ARMOR_STATS, statsWrappers.stream().filter(w -> w.hasStats(List.of(PlatingMaterialStats.HELMET.getId(), PlatingMaterialStats.CHESTPLATE.getId(), PlatingMaterialStats.LEGGINGS.getId(), PlatingMaterialStats.BOOTS.getId(), PlatingMaterialStats.SHIELD.getId(), StatlessMaterialStats.MAILLE.getIdentifier(), StatlessMaterialStats.SHIELD_CORE.getIdentifier()))).toList());
        registration.addRecipes(TOOL_PARTS, this.toolDefinitions());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new HarvestStatsCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RangedStatsCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ArmorStatsCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ToolPartsCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TinkerTables.tinkerStation.m_5456_()), new RecipeType[]{HARVEST_STATS, RANGED_STATS, TOOL_PARTS, ARMOR_STATS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TinkerTables.tinkersAnvil.m_5456_()), new RecipeType[]{HARVEST_STATS, RANGED_STATS, TOOL_PARTS, ARMOR_STATS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TinkerTables.scorchedAnvil.m_5456_()), new RecipeType[]{HARVEST_STATS, RANGED_STATS, TOOL_PARTS, ARMOR_STATS});
    }

    private List<ToolStatsWrapper> materials() {
        return MaterialRegistry.getInstance().getVisibleMaterials().stream().map(ToolStatsWrapper::new).collect(Collectors.toList());
    }

    private List<ToolPartsWrapper> toolDefinitions() {
        return ToolDefinitionLoader.getInstance().getRegisteredToolDefinitions().stream().filter(definition -> definition.hasMaterials() && !definition.getId().equals((Object)new ResourceLocation("tconstruct", "slime_helmet"))).sorted(Comparator.comparingInt(a -> StationSlotLayoutLoader.getInstance().get(a.getId()).getSortIndex())).map(ToolPartsWrapper::new).toList();
    }
}

