/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.paypur.tconjei.ColorManager;
import me.paypur.tconjei.jei.AbstractToolStatsCategory;
import me.paypur.tconjei.jei.ToolStatsWrapper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeI18n;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class RangedStatsCategory
extends AbstractToolStatsCategory {
    public RangedStatsCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.icon = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/jei.png"), 16, 0, 16, 16);
        this.title = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Ranged Stats"));
        this.recipeType = RecipeType.create((String)"tconjei", (String)"ranged_stats", ToolStatsWrapper.class);
        this.tag = TinkerTags.Items.RANGED;
    }

    public void draw(ToolStatsWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        String MATERIAL_NAME = ForgeI18n.getPattern((String)Util.makeTranslationKey((String)"material", (ResourceLocation)recipe.getMaterialId()));
        int MATERIAL_COLOR = MaterialTooltipCache.getColor((MaterialVariantId)recipe.getMaterialId()).m_131265_();
        float lineNumber = 2.0f;
        Optional limbOptional = recipe.getStats(LimbMaterialStats.ID);
        Optional gripOptional = recipe.getStats(GripMaterialStats.ID);
        Optional stringOptional = recipe.getStats(StatlessMaterialStats.BOWSTRING.getIdentifier());
        this.drawShadow(stack, MATERIAL_NAME, (172 - FONT.m_92895_(MATERIAL_NAME)) / 2, 0.5f, MATERIAL_COLOR);
        Optional<IMaterialStats> statOptional = Stream.of(limbOptional, gripOptional, stringOptional).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (statOptional.isPresent()) {
            this.drawTraits(stack, recipe.getTraits(statOptional.get().getIdentifier()), lineNumber);
        }
        if (limbOptional.isPresent()) {
            LimbMaterialStats limb = (LimbMaterialStats)limbOptional.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, String.format("[%s]", limb.getLocalizedName().getString()), 0, f, MATERIAL_COLOR);
            float f2 = lineNumber;
            lineNumber = f2 + 1.0f;
            this.drawStatsShadow(stack, (Component)limb.getLocalizedInfo().get(0), f2, ColorManager.DURABILITY_COLOR);
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            this.drawStatsShadow(stack, (Component)limb.getLocalizedInfo().get(1), f3, ColorManager.getMultiplierColor(limb.drawSpeed()));
            float f4 = lineNumber;
            lineNumber = f4 + 1.0f;
            this.drawStatsShadow(stack, (Component)limb.getLocalizedInfo().get(2), f4, ColorManager.getMultiplierColor(limb.velocity()));
            float f5 = lineNumber;
            lineNumber = f5 + 1.0f;
            this.drawStatsShadow(stack, (Component)limb.getLocalizedInfo().get(3), f5, ColorManager.getMultiplierColor(limb.accuracy()));
            lineNumber += 0.5f;
        }
        if (gripOptional.isPresent()) {
            GripMaterialStats grip = (GripMaterialStats)gripOptional.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, String.format("[%s]", grip.getLocalizedName().getString()), 0, f, MATERIAL_COLOR);
            float f6 = lineNumber;
            lineNumber = f6 + 1.0f;
            this.drawStatsShadow(stack, (Component)grip.getLocalizedInfo().get(0), f6, ColorManager.getMultiplierColor(grip.durability()));
            float f7 = lineNumber;
            lineNumber = f7 + 1.0f;
            this.drawStatsShadow(stack, (Component)grip.getLocalizedInfo().get(1), f7, ColorManager.getMultiplierColor(grip.accuracy()));
            float f8 = lineNumber;
            lineNumber = f8 + 1.0f;
            this.drawStatsShadow(stack, (Component)grip.getLocalizedInfo().get(2), f8, ColorManager.ATTACK_COLOR);
            lineNumber += 0.5f;
        }
        if (stringOptional.isPresent()) {
            StatlessMaterialStats string = (StatlessMaterialStats)stringOptional.get();
            this.drawShadow(stack, String.format("[%s]", string.getLocalizedName().getString()), 0, lineNumber, MATERIAL_COLOR);
        }
    }

    @Override
    @Nonnull
    public List<Component> getTooltipStrings(ToolStatsWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Optional<List> component;
        List<Component> tooltips;
        float lineNumber = 2.0f;
        Optional limbOptional = recipe.getStats(LimbMaterialStats.ID);
        Optional gripOptional = recipe.getStats(GripMaterialStats.ID);
        Optional stringOptional = recipe.getStats(StatlessMaterialStats.BOWSTRING.getIdentifier());
        List<Component> material = super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
        if (!material.isEmpty()) {
            return material;
        }
        Optional<IMaterialStats> statOptional = Stream.of(limbOptional, gripOptional, stringOptional).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (statOptional.isPresent() && !(tooltips = this.getTraitTooltips(recipe.getTraits(statOptional.get().getIdentifier()), mouseX, mouseY, lineNumber)).isEmpty()) {
            return tooltips;
        }
        if (limbOptional.isPresent()) {
            LimbMaterialStats limb = (LimbMaterialStats)limbOptional.get();
            List[] listArray = new List[4];
            float f = lineNumber += 1.0f;
            lineNumber = f + 1.0f;
            listArray[0] = this.getStatTooltip((IMaterialStats)limb, 0, mouseX, mouseY, f);
            float f2 = lineNumber;
            lineNumber = f2 + 1.0f;
            listArray[1] = this.getStatTooltip((IMaterialStats)limb, 1, mouseX, mouseY, f2);
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            listArray[2] = this.getStatTooltip((IMaterialStats)limb, 2, mouseX, mouseY, f3);
            float f4 = lineNumber;
            lineNumber = f4 + 1.0f;
            listArray[3] = this.getStatTooltip((IMaterialStats)limb, 3, mouseX, mouseY, f4);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
            lineNumber += 0.5f;
        }
        if (gripOptional.isPresent()) {
            GripMaterialStats grip = (GripMaterialStats)gripOptional.get();
            List[] listArray = new List[3];
            float f = lineNumber += 1.0f;
            lineNumber = f + 1.0f;
            listArray[0] = this.getStatTooltip((IMaterialStats)grip, 0, mouseX, mouseY, f);
            float f5 = lineNumber;
            lineNumber = f5 + 1.0f;
            listArray[1] = this.getStatTooltip((IMaterialStats)grip, 1, mouseX, mouseY, f5);
            listArray[2] = this.getStatTooltip((IMaterialStats)grip, 2, mouseX, mouseY, lineNumber);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
        }
        return List.of();
    }
}

