/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.paypur.tconjei.ColorManager;
import me.paypur.tconjei.jei.AbstractToolStatsCategory;
import me.paypur.tconjei.jei.ToolStatsWrapper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeI18n;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class HarvestStatsCategory
extends AbstractToolStatsCategory {
    public HarvestStatsCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.icon = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/jei.png"), 0, 0, 16, 16);
        this.title = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Harvest Stats"));
        this.recipeType = RecipeType.create((String)"tconjei", (String)"harvest_stats", ToolStatsWrapper.class);
        this.tag = TinkerTags.Items.HARVEST;
    }

    public void draw(ToolStatsWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        String MATERIAL_NAME = ForgeI18n.getPattern((String)Util.makeTranslationKey((String)"material", (ResourceLocation)recipe.getMaterialId()));
        int MATERIAL_COLOR = MaterialTooltipCache.getColor((MaterialVariantId)recipe.getMaterialId()).m_131265_();
        float lineNumber = 2.0f;
        Optional headOptional = recipe.getStats(HeadMaterialStats.ID);
        Optional bindingOptional = recipe.getStats(StatlessMaterialStats.BINDING.getIdentifier());
        Optional handleOptional = recipe.getStats(HandleMaterialStats.ID);
        this.drawShadow(stack, MATERIAL_NAME, (172 - FONT.m_92895_(MATERIAL_NAME)) / 2, 0.5f, MATERIAL_COLOR);
        Optional<IMaterialStats> statOptional = Stream.of(headOptional, bindingOptional, handleOptional).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (statOptional.isPresent()) {
            this.drawTraits(stack, recipe.getTraits(statOptional.get().getIdentifier()), lineNumber);
        }
        if (headOptional.isPresent()) {
            HeadMaterialStats head = (HeadMaterialStats)headOptional.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, String.format("[%s]", head.getLocalizedName().getString()), 0, f, MATERIAL_COLOR);
            float f2 = lineNumber;
            lineNumber = f2 + 1.0f;
            this.drawStatsShadow(stack, (Component)head.getLocalizedInfo().get(0), f2, ColorManager.DURABILITY_COLOR);
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            this.drawStatsShadow(stack, (Component)head.getLocalizedInfo().get(1), f3, ((Component)((Component)head.getLocalizedInfo().get(1)).m_7360_().get(0)).m_7383_().m_131135_().m_131265_());
            float f4 = lineNumber;
            lineNumber = f4 + 1.0f;
            this.drawStatsShadow(stack, (Component)head.getLocalizedInfo().get(2), f4, ColorManager.MINING_COLOR);
            float f5 = lineNumber;
            lineNumber = f5 + 1.0f;
            this.drawStatsShadow(stack, (Component)head.getLocalizedInfo().get(3), f5, ColorManager.ATTACK_COLOR);
            lineNumber += 0.5f;
        }
        if (bindingOptional.isPresent()) {
            StatlessMaterialStats binding = (StatlessMaterialStats)bindingOptional.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, String.format("[%s]", binding.getLocalizedName().getString()), 0, f, MATERIAL_COLOR);
            lineNumber += 0.5f;
        }
        if (handleOptional.isPresent()) {
            HandleMaterialStats handle = (HandleMaterialStats)handleOptional.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, String.format("[%s]", handle.getLocalizedName().getString()), 0, f, MATERIAL_COLOR);
            float f6 = lineNumber;
            lineNumber = f6 + 1.0f;
            this.drawStatsShadow(stack, (Component)handle.getLocalizedInfo().get(0), f6, ColorManager.getMultiplierColor(handle.durability()));
            float f7 = lineNumber;
            lineNumber = f7 + 1.0f;
            this.drawStatsShadow(stack, (Component)handle.getLocalizedInfo().get(1), f7, ColorManager.getMultiplierColor(handle.attackDamage()));
            float f8 = lineNumber;
            lineNumber = f8 + 1.0f;
            this.drawStatsShadow(stack, (Component)handle.getLocalizedInfo().get(2), f8, ColorManager.getMultiplierColor(handle.durability()));
            this.drawStatsShadow(stack, (Component)handle.getLocalizedInfo().get(3), lineNumber, ColorManager.getMultiplierColor(handle.attackDamage()));
        }
    }

    @Override
    @Nonnull
    public List<Component> getTooltipStrings(ToolStatsWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Optional<List> component;
        List<Component> tooltips;
        float lineNumber = 2.0f;
        Optional headOptional = recipe.getStats(HeadMaterialStats.ID);
        Optional extraOptional = recipe.getStats(StatlessMaterialStats.BINDING.getIdentifier());
        Optional handleOptional = recipe.getStats(HandleMaterialStats.ID);
        List<Component> material = super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
        if (!material.isEmpty()) {
            return material;
        }
        Optional<IMaterialStats> statOptional = Stream.of(handleOptional, extraOptional, handleOptional).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (statOptional.isPresent() && !(tooltips = this.getTraitTooltips(recipe.getTraits(statOptional.get().getIdentifier()), mouseX, mouseY, lineNumber)).isEmpty()) {
            return tooltips;
        }
        if (headOptional.isPresent()) {
            HeadMaterialStats head = (HeadMaterialStats)headOptional.get();
            List[] listArray = new List[4];
            float f = lineNumber += 1.0f;
            lineNumber = f + 1.0f;
            listArray[0] = this.getStatTooltip((IMaterialStats)head, 0, mouseX, mouseY, f);
            float f2 = lineNumber;
            lineNumber = f2 + 1.0f;
            listArray[1] = this.getStatTooltip((IMaterialStats)head, 1, mouseX, mouseY, f2);
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            listArray[2] = this.getStatTooltip((IMaterialStats)head, 2, mouseX, mouseY, f3);
            float f4 = lineNumber;
            lineNumber = f4 + 1.0f;
            listArray[3] = this.getStatTooltip((IMaterialStats)head, 3, mouseX, mouseY, f4);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
            lineNumber += 0.5f;
        }
        if (extraOptional.isPresent()) {
            lineNumber += 1.5f;
        }
        if (handleOptional.isPresent()) {
            HandleMaterialStats handle = (HandleMaterialStats)handleOptional.get();
            List[] listArray = new List[4];
            float f = lineNumber += 1.0f;
            lineNumber = f + 1.0f;
            listArray[0] = this.getStatTooltip((IMaterialStats)handle, 0, mouseX, mouseY, f);
            float f5 = lineNumber;
            lineNumber = f5 + 1.0f;
            listArray[1] = this.getStatTooltip((IMaterialStats)handle, 1, mouseX, mouseY, f5);
            float f6 = lineNumber;
            lineNumber = f6 + 1.0f;
            listArray[2] = this.getStatTooltip((IMaterialStats)handle, 2, mouseX, mouseY, f6);
            listArray[3] = this.getStatTooltip((IMaterialStats)handle, 3, mouseX, mouseY, lineNumber);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
        }
        return List.of();
    }
}

