/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import me.paypur.tconjei.ColorManager;
import me.paypur.tconjei.Utils;
import me.paypur.tconjei.jei.AbstractToolStatsCategory;
import me.paypur.tconjei.jei.ToolStatsWrapper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeI18n;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class ArmorStatsCategory
extends AbstractToolStatsCategory {
    public ArmorStatsCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.icon = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/jei.png"), 32, 0, 16, 16);
        this.title = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Armor Stats"));
        this.recipeType = RecipeType.create((String)"tconjei", (String)"armor_stats", ToolStatsWrapper.class);
        this.tag = TinkerTags.Items.ARMOR;
    }

    public void draw(ToolStatsWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Optional<PlatingMaterialStats> platingStats;
        String MATERIAL_NAME = ForgeI18n.getPattern((String)Util.makeTranslationKey((String)"material", (ResourceLocation)recipe.getMaterialId()));
        int MATERIAL_COLOR = MaterialTooltipCache.getColor((MaterialVariantId)recipe.getMaterialId()).m_131265_();
        float lineNumber = 2.0f;
        Optional helmetOptional = recipe.getStats(PlatingMaterialStats.HELMET.getId());
        Optional chestplateOptional = recipe.getStats(PlatingMaterialStats.CHESTPLATE.getId());
        Optional leggingsOptional = recipe.getStats(PlatingMaterialStats.LEGGINGS.getId());
        Optional bootsOptional = recipe.getStats(PlatingMaterialStats.BOOTS.getId());
        Optional shieldOptional = recipe.getStats(PlatingMaterialStats.SHIELD.getId());
        Optional coreOptional = recipe.getStats(StatlessMaterialStats.SHIELD_CORE.getIdentifier());
        Optional mailleOptional = recipe.getStats(StatlessMaterialStats.MAILLE.getIdentifier());
        this.drawShadow(stack, MATERIAL_NAME, (172 - FONT.m_92895_(MATERIAL_NAME)) / 2, 0.5f, MATERIAL_COLOR);
        Optional<IMaterialStats> statOptional = Stream.of(helmetOptional, chestplateOptional, leggingsOptional, bootsOptional, shieldOptional, coreOptional, mailleOptional).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (statOptional.isPresent()) {
            this.drawTraits(stack, recipe.getTraits(statOptional.get().getIdentifier()), lineNumber);
        }
        ArrayList<ArmorStat> armorStats = new ArrayList<ArmorStat>();
        if (helmetOptional.isPresent()) {
            PlatingMaterialStats helmet = (PlatingMaterialStats)helmetOptional.get();
            armorStats.add(new ArmorStat(helmet.getLocalizedName().getString(), helmet.durability(), helmet.armor()));
        }
        if (chestplateOptional.isPresent()) {
            PlatingMaterialStats chestplate = (PlatingMaterialStats)chestplateOptional.get();
            armorStats.add(new ArmorStat(chestplate.getLocalizedName().getString(), chestplate.durability(), chestplate.armor()));
        }
        if (leggingsOptional.isPresent()) {
            PlatingMaterialStats leggings = (PlatingMaterialStats)leggingsOptional.get();
            armorStats.add(new ArmorStat(leggings.getLocalizedName().getString(), leggings.durability(), leggings.armor()));
        }
        if (bootsOptional.isPresent()) {
            PlatingMaterialStats boots = (PlatingMaterialStats)bootsOptional.get();
            armorStats.add(new ArmorStat(boots.getLocalizedName().getString(), boots.durability(), boots.armor()));
        }
        if (shieldOptional.isPresent()) {
            PlatingMaterialStats shield = (PlatingMaterialStats)shieldOptional.get();
            armorStats.add(new ArmorStat(shield.getLocalizedName().getString(), shield.durability(), shield.armor()));
        }
        if ((platingStats = Stream.of(helmetOptional, chestplateOptional, leggingsOptional, bootsOptional, shieldOptional).filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
            PlatingMaterialStats plating = platingStats.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, String.format("[%s]", ForgeI18n.getPattern((String)"stat.tconstruct.plating")), 0, f, MATERIAL_COLOR);
            String durabilityText = Utils.colonSplit(((Component)plating.getLocalizedInfo().get(0)).getString())[0] + " ";
            String armorText = Utils.colonSplit(((Component)plating.getLocalizedInfo().get(1)).getString())[0] + " ";
            int durabilityTextWidth = FONT.m_92895_(durabilityText);
            int armorTextWidth = FONT.m_92895_(armorText);
            int maxTextWidth = FONT.m_92895_(Collections.max(armorStats, Comparator.comparingInt((ToIntFunction<ArmorStat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$draw$0(me.paypur.tconjei.jei.ArmorStatsCategory$ArmorStat ), (Lme/paypur/tconjei/jei/ArmorStatsCategory$ArmorStat;)I)())).text);
            int maxArmorWidth = FONT.m_92895_(Collections.max(armorStats, Comparator.comparingInt((ToIntFunction<ArmorStat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$draw$1(me.paypur.tconjei.jei.ArmorStatsCategory$ArmorStat ), (Lme/paypur/tconjei/jei/ArmorStatsCategory$ArmorStat;)I)())).armor);
            int maxDurabilityWidth = FONT.m_92895_(Collections.max(armorStats, Comparator.comparingInt((ToIntFunction<ArmorStat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$draw$2(me.paypur.tconjei.jei.ArmorStatsCategory$ArmorStat ), (Lme/paypur/tconjei/jei/ArmorStatsCategory$ArmorStat;)I)())).durability);
            String line = "\u2500";
            int lineWidth = FONT.m_92895_(line);
            int durabilityLine = (maxTextWidth + maxArmorWidth + maxDurabilityWidth - durabilityTextWidth) / lineWidth - 1;
            int armorLine = (maxTextWidth + maxArmorWidth - armorTextWidth) / lineWidth - 1;
            this.draw(stack, durabilityText, 0, lineNumber, ColorManager.TEXT_COLOR);
            float f2 = lineNumber;
            lineNumber = f2 + 1.0f;
            this.drawShadow(stack, line.repeat(durabilityLine) + "\u2510", durabilityTextWidth, f2, ColorManager.DURABILITY_COLOR);
            this.drawShadow(stack, "\u2502", durabilityTextWidth + lineWidth * durabilityLine, lineNumber, ColorManager.DURABILITY_COLOR);
            this.draw(stack, armorText, 0, lineNumber, ColorManager.TEXT_COLOR);
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            this.drawShadow(stack, line.repeat(armorLine) + "\u2510", armorTextWidth, f3, ColorManager.ARMOR_COLOR);
            for (ArmorStat armorStat : armorStats) {
                this.draw(stack, armorStat.text, 0, lineNumber, ColorManager.TEXT_COLOR);
                this.drawShadow(stack, armorStat.armor, maxTextWidth, lineNumber, ColorManager.ARMOR_COLOR);
                float f4 = lineNumber;
                lineNumber = f4 + 1.0f;
                this.drawShadow(stack, armorStat.durability, maxTextWidth + maxArmorWidth, f4, ColorManager.DURABILITY_COLOR);
            }
            float f5 = lineNumber;
            lineNumber = f5 + 1.0f;
            this.drawStatsShadow(stack, (Component)plating.getLocalizedInfo().get(2), f5, ColorManager.ARMOR_COLOR);
            float f6 = lineNumber;
            lineNumber = f6 + 1.0f;
            this.drawStatsShadow(stack, (Component)plating.getLocalizedInfo().get(3), f6, ColorManager.ARMOR_COLOR);
            lineNumber += 0.5f;
        }
        if (coreOptional.isPresent()) {
            StatlessMaterialStats core = (StatlessMaterialStats)coreOptional.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, String.format("[%s]", core.getLocalizedName().getString()), 0, f, MATERIAL_COLOR);
            lineNumber += 0.5f;
        }
        if (mailleOptional.isPresent()) {
            StatlessMaterialStats maille = (StatlessMaterialStats)mailleOptional.get();
            this.drawShadow(stack, String.format("[%s]", maille.getLocalizedName().getString()), 0, lineNumber, MATERIAL_COLOR);
        }
    }

    @Override
    public List<Component> getTooltipStrings(ToolStatsWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        List<Component> tooltips;
        float lineNumber = 2.0f;
        Optional helmetOptional = recipe.getStats(PlatingMaterialStats.HELMET.getId());
        Optional chestplateOptional = recipe.getStats(PlatingMaterialStats.CHESTPLATE.getId());
        Optional leggingsOptional = recipe.getStats(PlatingMaterialStats.LEGGINGS.getId());
        Optional bootsOptional = recipe.getStats(PlatingMaterialStats.BOOTS.getId());
        Optional shieldOptional = recipe.getStats(PlatingMaterialStats.SHIELD.getId());
        Optional coreOptional = recipe.getStats(StatlessMaterialStats.SHIELD_CORE.getIdentifier());
        Optional mailleOptional = recipe.getStats(StatlessMaterialStats.MAILLE.getIdentifier());
        List<Component> material = super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
        if (!material.isEmpty()) {
            return material;
        }
        Optional<IMaterialStats> statOptional = Stream.of(helmetOptional, chestplateOptional, leggingsOptional, bootsOptional, shieldOptional, coreOptional, mailleOptional).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (statOptional.isPresent() && !(tooltips = this.getTraitTooltips(recipe.getTraits(statOptional.get().getIdentifier()), mouseX, mouseY, lineNumber)).isEmpty()) {
            return tooltips;
        }
        Optional<PlatingMaterialStats> platingStats = Stream.of(helmetOptional, chestplateOptional, leggingsOptional, bootsOptional, shieldOptional).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (platingStats.isPresent()) {
            PlatingMaterialStats plating = platingStats.get();
            List[] listArray = new List[2];
            float f = lineNumber += 1.0f;
            lineNumber = f + 1.0f;
            listArray[0] = this.getStatTooltip((IMaterialStats)plating, 0, mouseX, mouseY, f);
            listArray[1] = this.getStatTooltip((IMaterialStats)plating, 1, mouseX, mouseY, lineNumber);
            Stream<List> stream = Stream.of(listArray);
            List[] listArray2 = new List[2];
            float f2 = lineNumber += 6.0f;
            lineNumber = f2 + 1.0f;
            listArray2[0] = this.getStatTooltip((IMaterialStats)plating, 2, mouseX, mouseY, f2);
            listArray2[1] = this.getStatTooltip((IMaterialStats)plating, 3, mouseX, mouseY, lineNumber);
            Optional<List> component = (stream = Stream.concat(stream, Stream.of(listArray2))).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
        }
        return List.of();
    }

    private static /* synthetic */ int lambda$draw$2(ArmorStat s) {
        return FONT.m_92895_(s.durability);
    }

    private static /* synthetic */ int lambda$draw$1(ArmorStat s) {
        return FONT.m_92895_(s.armor);
    }

    private static /* synthetic */ int lambda$draw$0(ArmorStat s) {
        return FONT.m_92895_(s.text);
    }

    private record ArmorStat(String text, String durability, String armor) {
        private ArmorStat(String text, int durability, float armor) {
            this(text.split(" ")[0] + ": ", String.valueOf(durability), armor + " ");
        }
    }
}

