/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.paypur.tconjei.ColorManager;
import me.paypur.tconjei.TConJEI;
import me.paypur.tconjei.Utils;
import me.paypur.tconjei.jei.ToolStatsWrapper;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.utils.Util;

public abstract class AbstractToolStatsCategory
implements IRecipeCategory<ToolStatsWrapper> {
    protected static final Font FONT = Minecraft.m_91087_().f_91062_;
    protected static final int LINE_HEIGHT = 10;
    protected static final float LINE_SPACING = 0.5f;
    protected static final int WIDTH = 172;
    protected static final int HEIGHT = 200;
    protected Component title;
    protected RecipeType<ToolStatsWrapper> recipeType;
    protected IDrawable background;
    protected IDrawable icon;
    protected TagKey<Item> tag;

    public AbstractToolStatsCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(172, 200);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ToolStatsWrapper recipe, IFocusGroup focuses) {
        FluidStack fluidStack = recipe.getFluidStack();
        if (!fluidStack.isEmpty()) {
            int BUCKET = 1000;
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 18, 0).addFluidStack(fluidStack.getFluid(), 1000L);
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addFluidStack(fluidStack.getFluid(), 1000L);
        }
        List<ItemStack> inputs = recipe.getInputs();
        List<ItemStack> inputsParts = recipe.getInputsParts(this.tag);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStacks(inputs);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 156, 0).addItemStacks(inputsParts);
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(inputs);
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(inputsParts);
    }

    public List<Component> getTooltipStrings(ToolStatsWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        String MATERIAL_NAME = ForgeI18n.getPattern((String)Util.makeTranslationKey((String)"material", (ResourceLocation)recipe.getMaterialId()));
        int materialWidth = FONT.m_92895_(MATERIAL_NAME);
        if (TConJEI.inBox(mouseX, mouseY, (float)(172 - materialWidth) / 2.0f, 3.0f, materialWidth, 10.0f)) {
            return List.of(MutableComponent.m_237204_((ComponentContents)new TranslatableContents(Util.makeTranslationKey((String)"material", (ResourceLocation)recipe.getMaterialId()) + ".flavor")).m_130940_(ChatFormatting.ITALIC));
        }
        return List.of();
    }

    protected void draw(PoseStack stack, String string, int x, float lineNumber, int color) {
        FONT.m_92883_(stack, string, (float)x, lineNumber * 10.0f, color);
    }

    protected void drawShadow(PoseStack stack, String string, int x, float lineNumber, int color) {
        this.draw(stack, string, x + 1, lineNumber + 0.1f, ColorManager.getShade(color, 6.0f));
        this.draw(stack, string, x, lineNumber, color);
    }

    protected void drawStatsShadow(PoseStack stack, Component component, float lineNumber, int color) {
        String[] strings = Utils.colonSplit(component.getString());
        int width = FONT.m_92895_(strings[0]);
        this.draw(stack, strings[0], 0, lineNumber, ColorManager.TEXT_COLOR);
        this.drawShadow(stack, strings[1], width, lineNumber, color);
    }

    protected void drawTraits(PoseStack stack, List<ModifierEntry> traits, float lineNumber) {
        for (ModifierEntry trait : traits) {
            String pattern = ForgeI18n.getPattern((String)Util.makeTranslationKey((String)"modifier", (ResourceLocation)trait.getId()));
            int traitColor = ResourceColorManager.getColor((String)Util.makeTranslationKey((String)"modifier", (ResourceLocation)trait.getId()));
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawShadow(stack, pattern, 172 - FONT.m_92895_(pattern), f, traitColor);
        }
    }

    protected List<Component> getStatTooltip(IMaterialStats stats, int i, double mouseX, double mouseY, float lineNumber) {
        int textWidth = FONT.m_92895_(Utils.colonSplit(((Component)stats.getLocalizedInfo().get(i)).getString())[0]);
        if (TConJEI.inBox(mouseX, mouseY, 0.0f, lineNumber * 10.0f - 1.0f, textWidth, 10.0f)) {
            return List.of((Component)stats.getLocalizedDescriptions().get(i));
        }
        return List.of();
    }

    protected List<Component> getTraitTooltips(List<ModifierEntry> traits, double mouseX, double mouseY, float lineNumber) {
        for (ModifierEntry trait : traits) {
            int textWidth = FONT.m_92895_(ForgeI18n.getPattern((String)Util.makeTranslationKey((String)"modifier", (ResourceLocation)trait.getId())));
            float f = lineNumber;
            lineNumber = f + 1.0f;
            if (!TConJEI.inBox(mouseX, mouseY, 172 - textWidth, f * 10.0f - 1.0f, textWidth, 10.0f)) continue;
            return List.of(MutableComponent.m_237204_((ComponentContents)new TranslatableContents(Util.makeTranslationKey((String)"modifier", (ResourceLocation)trait.getId()) + ".flavor")).m_130940_(ChatFormatting.ITALIC), MutableComponent.m_237204_((ComponentContents)new TranslatableContents(Util.makeTranslationKey((String)"modifier", (ResourceLocation)trait.getId()) + ".description")));
        }
        return List.of();
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public RecipeType<ToolStatsWrapper> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

