/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.tconstruct.library.utils.Util;

public class ColorManager {
    public static final int WHITE = 0xFFFFFF;
    public static final int BLACK = 0;
    public static int TEXT_COLOR = 0x3F3F3F;
    public static int DURABILITY_COLOR = 0x47CC47;
    public static int MINING_COLOR = 7905485;
    public static int ATTACK_COLOR = 14115940;
    public static int ARMOR_COLOR = 8603338;
    static ResourceLocation palette = new ResourceLocation("tconjei", "textures/gui/palette.png");

    public static float luminance(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return (float)((double)0.2126f * Math.pow(r, 2.2) + (double)0.7152f * Math.pow(g, 2.2) + (double)0.0722f * Math.pow(b, 2.2));
    }

    public static float contrast(float luminance1, float luminance2) {
        return (Math.max(luminance1, luminance2) + 0.05f) / (Math.min(luminance1, luminance2) + 0.05f);
    }

    public static int getShade(int color, float contrastRatio) {
        float colorLuminance = ColorManager.luminance(color);
        float factor = 0.0f;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float[] hsb = new float[3];
        Color.RGBtoHSB(r, g, b, hsb);
        if (ColorManager.contrast(colorLuminance, 0.0f) > contrastRatio) {
            factor = (float)Math.pow((colorLuminance + 0.05f - contrastRatio * 0.05f) / (contrastRatio * colorLuminance), 0.45454543828964233);
        }
        return Color.HSBtoRGB(hsb[0], hsb[1], hsb[2] * factor);
    }

    public static int getMiningLevelColor(ResourceLocation miningLevel) {
        return ResourceColorManager.getColor((String)Util.makeTranslationKey((String)"harvest_tier", (ResourceLocation)miningLevel));
    }

    public static int getMultiplierColor(float f) {
        if ((f += 1.0f) < 0.55f) {
            return 0xBD0000;
        }
        if (f < 0.6f) {
            return 12396032;
        }
        if (f < 0.65f) {
            return 12405504;
        }
        if (f < 0.7f) {
            return 12415232;
        }
        if (f < 0.75f) {
            return 12424960;
        }
        if (f < 0.8f) {
            return 0xBDBD00;
        }
        if (f < 0.85f) {
            return 9944320;
        }
        if (f < 0.9f) {
            return 7453952;
        }
        if (f < 0.95f) {
            return 4963584;
        }
        if (f < 1.0f) {
            return 2538752;
        }
        if (f < 1.05f) {
            return 48384;
        }
        if (f < 1.1f) {
            return 48422;
        }
        if (f < 1.15f) {
            return 48459;
        }
        if (f < 1.2f) {
            return 48497;
        }
        if (f < 1.25f) {
            return 48535;
        }
        if (f < 1.3f) {
            return 48573;
        }
        if (f < 1.35f) {
            return 38845;
        }
        if (f < 1.4f) {
            return 29117;
        }
        return 19389;
    }

    @Mod.EventBusSubscriber(modid="tconjei", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public final class ClientForgeHandler {
        @SubscribeEvent
        public static void onClientReload(TextureStitchEvent.Post event) {
            try {
                InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(palette).get()).m_215507_();
                BufferedImage image = ImageIO.read(stream);
                TEXT_COLOR = image.getRGB(0, 0);
                DURABILITY_COLOR = image.getRGB(1, 0);
                MINING_COLOR = image.getRGB(0, 1);
                ATTACK_COLOR = image.getRGB(1, 1);
                stream.close();
            }
            catch (IOException e) {
                LogUtils.getLogger().error("Error loading palette", (Throwable)e);
            }
        }
    }
}

