/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.stats;

import com.gjhi.tinkersinnovation.TinkersInnovation;
import com.gjhi.tinkersinnovation.register.TinkersInnovationToolStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record ShieldMaterialStats(int durability, float armor, float toughness, float knockback_resistance, float block_amount, int shield_amount) implements IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TinkersInnovation.getResource("shield_plate"));
    public static final MaterialStatType<ShieldMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new ShieldMaterialStats(1, 0.0f, 0.0f, 0.0f, 0.0f, 1), RecordLoadable.create((RecordField)IRepairableMaterialStats.DURABILITY_FIELD, (RecordField)FloatLoadable.FROM_ZERO.defaultField("armor", (Object)Float.valueOf(0.0f), true, ShieldMaterialStats::armor), (RecordField)FloatLoadable.FROM_ZERO.defaultField("toughness", (Object)Float.valueOf(0.0f), true, ShieldMaterialStats::toughness), (RecordField)FloatLoadable.FROM_ZERO.defaultField("knockback_resistance", (Object)Float.valueOf(0.0f), true, ShieldMaterialStats::knockback_resistance), (RecordField)FloatLoadable.ANY.defaultField("block_amount", (Object)Float.valueOf(0.0f), true, ShieldMaterialStats::block_amount), (RecordField)IntLoadable.FROM_ZERO.defaultField("shield_amount", (Object)5, true, ShieldMaterialStats::shield_amount), ShieldMaterialStats::new));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.ARMOR.getDescription(), (Object)ToolStats.ARMOR_TOUGHNESS.getDescription(), (Object)ToolStats.KNOCKBACK_RESISTANCE.getDescription(), (Object)ToolStats.BLOCK_AMOUNT.getDescription(), (Object)TinkersInnovationToolStats.SHIELD_AMOUNT.getDescription());

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue((float)this.durability));
        info.add(ToolStats.ARMOR.formatValue(this.armor));
        info.add(ToolStats.ARMOR_TOUGHNESS.formatValue(this.toughness));
        info.add(ToolStats.KNOCKBACK_RESISTANCE.formatValue(this.knockback_resistance));
        info.add(ToolStats.BLOCK_AMOUNT.formatValue(this.block_amount));
        info.add(TinkersInnovationToolStats.SHIELD_AMOUNT.formatValue((float)this.shield_amount));
        return info;
    }

    @NotNull
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.update(builder, Float.valueOf((float)this.durability * scale));
        ToolStats.ARMOR.update(builder, Float.valueOf(this.armor * scale));
        ToolStats.ARMOR_TOUGHNESS.update(builder, Float.valueOf(this.toughness * scale));
        ToolStats.KNOCKBACK_RESISTANCE.update(builder, Float.valueOf(this.knockback_resistance * scale));
        ToolStats.BLOCK_AMOUNT.percent(builder, (double)(this.block_amount * scale));
        TinkersInnovationToolStats.SHIELD_AMOUNT.update(builder, Float.valueOf((float)this.shield_amount * scale));
    }
}

