/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TraderModifier
extends Modifier
implements ProcessLootModifierHook {
    public TraderModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onExperienceDrop);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::beforeBlockBreak);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROCESS_LOOT);
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        int level = 0;
        ToolStack tool = TraderModifier.getHeldTool((LivingEntity)event.getPlayer(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel((Modifier)this);
        }
        if (level > 0) {
            event.setExpToDrop(0);
        }
    }

    private void onExperienceDrop(LivingExperienceDropEvent event) {
        int level = 0;
        ToolStack tool = TraderModifier.getHeldTool((LivingEntity)event.getAttackingPlayer(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel((Modifier)this);
        }
        if (level > 0) {
            event.setDroppedExperience(0);
        }
    }

    public void processLoot(@NotNull IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, @NotNull LootContext context) {
        generatedLoot.clear();
        if ((double)RANDOM.nextFloat() < 0.2 * (double)modifier.getLevel()) {
            generatedLoot.add(new ItemStack((ItemLike)Items.f_42616_));
        }
    }
}

