/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TeleportModifier
extends NoLevelsModifier
implements GeneralInteractionModifierHook,
MeleeHitModifierHook,
TooltipModifierHook {
    private final ResourceLocation X = new ResourceLocation("tinkersinnovation", "teleport_x");
    private final ResourceLocation Y = new ResourceLocation("tinkersinnovation", "teleport_y");
    private final ResourceLocation Z = new ResourceLocation("tinkersinnovation", "teleport_z");
    private final ResourceLocation WORLD = new ResourceLocation("tinkersinnovation", "teleport_dimension");
    private static final String TELEPORT_SUCCEED = Mantle.makeDescriptionId((String)"modifier", (String)"teleport.tp_successful");
    private static final String TELEPORT_FAILED = Mantle.makeDescriptionId((String)"modifier", (String)"teleport.tp_failed");
    private static final String LINK_SUCCEED = Mantle.makeDescriptionId((String)"modifier", (String)"teleport.link");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.GENERAL_INTERACT, ModifierHooks.MELEE_HIT, ModifierHooks.TOOLTIP);
    }

    public int getPriority() {
        return 10;
    }

    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && !tool.isBroken()) {
            if (player.m_6047_()) {
                if (!player.m_9236_().f_46443_) {
                    Level world = player.m_9236_();
                    ModDataNBT data = tool.getPersistentData();
                    data.putFloat(this.X, (float)player.m_20185_());
                    data.putFloat(this.Y, (float)player.m_20186_());
                    data.putFloat(this.Z, (float)player.m_20189_());
                    data.putString(this.WORLD, world.m_46472_().m_135782_().m_135815_());
                    ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)10, (LivingEntity)player);
                    player.m_36335_().m_41524_(tool.getItem(), 100);
                    player.m_5661_((Component)Component.m_237110_((String)LINK_SUCCEED, (Object[])new Object[]{Float.valueOf(data.getFloat(this.X)), Float.valueOf(data.getFloat(this.Y)), Float.valueOf(data.getFloat(this.Z))}), true);
                }
            } else if (!player.m_21023_((MobEffect)TinkerModifiers.teleportCooldownEffect.get()) || !player.m_21023_((MobEffect)TinkerModifiers.enderferenceEffect.get())) {
                Level world = player.m_9236_();
                ModDataNBT data = tool.getPersistentData();
                if (data.contains(this.X, 5) && data.contains(this.Y, 5) && data.contains(this.Z, 5) && data.contains(this.WORLD, 8)) {
                    if (data.getString(this.WORLD).equals(world.m_46472_().m_135782_().m_135815_())) {
                        player.m_6034_((double)data.getFloat(this.X), (double)data.getFloat(this.Y), (double)data.getFloat(this.Z));
                        ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)5, (LivingEntity)player);
                        player.m_7292_(new MobEffectInstance((MobEffect)TinkerModifiers.teleportCooldownEffect.get(), 100));
                        player.m_5661_((Component)Component.m_237110_((String)TELEPORT_SUCCEED, (Object[])new Object[]{Float.valueOf(data.getFloat(this.X)), Float.valueOf(data.getFloat(this.Y)), Float.valueOf(data.getFloat(this.Z))}), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)TELEPORT_FAILED), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.tinkersinnovation.teleport_pos_null"), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity target = context.getLivingTarget();
        if (!tool.isBroken() && target != null && !target.m_21023_((MobEffect)TinkerModifiers.enderferenceEffect.get())) {
            Level world = target.m_9236_();
            ModDataNBT data = tool.getPersistentData();
            if (data.contains(this.X, 5) && data.contains(this.Y, 5) && data.contains(this.Z, 5) && data.contains(this.WORLD, 8) && data.getString(this.WORLD).equals(world.m_46472_().m_135782_().m_135815_())) {
                target.m_6034_((double)data.getFloat(this.X), (double)data.getFloat(this.Y), (double)data.getFloat(this.Z));
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)5, (LivingEntity)context.getAttacker());
                return 0.0f;
            }
        }
        return knockback;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(this.X, 5) && data.contains(this.Y, 5) && data.contains(this.Z, 8)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.tinkersinnovation.teleport_pos", (Object[])new Object[]{Float.valueOf(data.getFloat(this.X)), Float.valueOf(data.getFloat(this.Y)), Float.valueOf(data.getFloat(this.Z))}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.tinkersinnovation.teleport_pos_null"));
        }
    }
}

