/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class PoseiditeBlessingModifier
extends NoLevelsModifier
implements AttributesModifierHook,
ModifierRemovalHook,
InventoryTickModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkersinnovation", "poseidite_blessing");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.ATTRIBUTES, ModifierHooks.REMOVE);
    }

    public void onInventoryTick(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        holder.m_21195_(MobEffects.f_19597_);
        if (holder.m_20072_()) {
            tool.getPersistentData().putBoolean(this.KEY, true);
            EquipmentSlot slot = TinkersInnovationUtils.inWhichSlot(holder, stack);
            if (slot != null) {
                if (TinkersInnovationUtils.isInArmorSlots(holder, stack)) {
                    switch (slot) {
                        case HEAD: 
                        case CHEST: {
                            holder.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 200));
                            break;
                        }
                        case FEET: 
                        case LEGS: {
                            holder.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 200));
                        }
                    }
                }
                if (TinkersInnovationUtils.isShieldInHandSlots(tool, holder, stack)) {
                    switch (slot) {
                        case MAINHAND: 
                        case OFFHAND: {
                            holder.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 200));
                            holder.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 200));
                        }
                    }
                }
            }
        } else {
            tool.getPersistentData().putBoolean(this.KEY, false);
        }
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        if (tool.getPersistentData().getBoolean(this.KEY)) {
            if (TinkersInnovationUtils.isInArmorSlots(slot)) {
                switch (slot) {
                    case HEAD: {
                        consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("03b6013c-6a49-48a7-92a9-9cba8a8a78cb"), Attributes.f_22284_.m_22087_(), 4.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("d70caf99-afef-40c9-ad5d-5167829d982f"), Attributes.f_22285_.m_22087_(), 2.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("0e6aa9d6-0eb3-4d2e-9737-1ffa6a9cb02d"), Attributes.f_22279_.m_22087_(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        consumer.accept((Attribute)ForgeMod.SWIM_SPEED.get(), new AttributeModifier(UUID.fromString("334b7ee5-d05f-4c41-b70f-afef270388df"), ((Attribute)ForgeMod.SWIM_SPEED.get()).m_22087_(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case CHEST: {
                        consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("5c60cb1e-f1b5-411f-8772-1c778e3417b2"), Attributes.f_22284_.m_22087_(), 6.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("e6698b5e-78cc-47f0-b30d-f57d6f27a1d6"), Attributes.f_22285_.m_22087_(), 3.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("801831f7-47c1-4a33-8c27-9c1e64de5a25"), Attributes.f_22279_.m_22087_(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
                        consumer.accept((Attribute)ForgeMod.SWIM_SPEED.get(), new AttributeModifier(UUID.fromString("b6c53715-783a-490e-b163-1ddb37e6f481"), ((Attribute)ForgeMod.SWIM_SPEED.get()).m_22087_(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case LEGS: {
                        consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("5af95ebd-e8a7-4d66-a9d9-178f0673d214"), Attributes.f_22284_.m_22087_(), 6.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("ec9e3981-6106-458d-b7b5-6578b5060edc"), Attributes.f_22285_.m_22087_(), 3.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("4a66c99c-bf89-4067-a28f-36fa1bb128ee"), Attributes.f_22279_.m_22087_(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
                        consumer.accept((Attribute)ForgeMod.SWIM_SPEED.get(), new AttributeModifier(UUID.fromString("f5295365-8c66-4e01-857e-b85de6bc2515"), ((Attribute)ForgeMod.SWIM_SPEED.get()).m_22087_(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
                        break;
                    }
                    case FEET: {
                        consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("d75727a1-c1b7-42cc-a58f-c87928f5c336"), Attributes.f_22284_.m_22087_(), 4.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("92af545d-83b5-4595-bce9-806ff79e3878"), Attributes.f_22285_.m_22087_(), 2.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("eed80e05-e680-4d41-ae3f-04c3ddea63d5"), Attributes.f_22279_.m_22087_(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                        consumer.accept((Attribute)ForgeMod.SWIM_SPEED.get(), new AttributeModifier(UUID.fromString("949d13a8-2501-44cb-a400-489a3c9fd291"), ((Attribute)ForgeMod.SWIM_SPEED.get()).m_22087_(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                }
            }
            if (TinkersInnovationUtils.isShieldInHandSlots(tool, slot)) {
                switch (slot) {
                    case MAINHAND: 
                    case OFFHAND: {
                        consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("6f57d755-97ef-4303-ad9e-81a74bf8f741"), Attributes.f_22285_.m_22087_(), 2.0, AttributeModifier.Operation.ADDITION));
                        consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("5826cd97-8fb1-47b2-9a15-d8bfa09eea5e"), Attributes.f_22279_.m_22087_(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
                        consumer.accept((Attribute)ForgeMod.SWIM_SPEED.get(), new AttributeModifier(UUID.fromString("bc622337-d4e0-46dc-85e6-5b3bd71f6664"), ((Attribute)ForgeMod.SWIM_SPEED.get()).m_22087_(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                }
            }
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }
}

