/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class NEOModifier
extends Modifier
implements AttributesModifierHook,
OnAttackedModifierHook,
ModifierRemovalHook,
EquipmentChangeModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkersinnovation", "neo");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.ON_ATTACKED, ModifierHooks.ATTRIBUTES, ModifierHooks.REMOVE, ModifierHooks.EQUIPMENT_CHANGE});
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        float boost;
        if (tool.hasTag(TinkerTags.Items.ARMOR) && (boost = tool.getPersistentData().getFloat(this.KEY)) > 0.0f) {
            consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("03230c69-3614-4ca5-9ab8-8e3d5c51cab2"), Attributes.f_22285_.m_22087_(), (double)((float)(5 * modifier.getLevel()) * boost), AttributeModifier.Operation.ADDITION));
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }

    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (tool.hasTag(TinkerTags.Items.ARMOR) && (double)tool.getDamage() / (double)tool.getCurrentDurability() < 1.0) {
            persistentData.putFloat(this.KEY, (float)tool.getDamage() / (float)tool.getCurrentDurability());
        }
    }

    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        ModDataNBT persistentData = tool.getPersistentData();
        if ((double)tool.getDamage() / (double)tool.getCurrentDurability() < 1.0) {
            persistentData.putFloat(this.KEY, (float)tool.getDamage() / (float)tool.getCurrentDurability());
        }
    }

    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        ModDataNBT persistentData = tool.getPersistentData();
        persistentData.remove(this.KEY);
    }
}

