/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class BlastingModifier
extends NoLevelsModifier
implements MeleeHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT);
    }

    public BlastingModifier() {
        MinecraftForge.EVENT_BUS.addListener(this::leftClickBlock);
    }

    private void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ToolStack tool = BlastingModifier.getHeldTool((LivingEntity)event.getEntity(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (tool != null && tool.getModifier((Modifier)this).getLevel() > 0) {
            event.getEntity().f_19853_.m_46518_(null, (double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_(), 4.0f, false, Explosion.BlockInteraction.BREAK);
            if (!event.getEntity().m_7500_()) {
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)10, (LivingEntity)event.getEntity(), (InteractionHand)null);
            }
        }
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity target = context.getLivingTarget();
        Player player = context.getPlayerAttacker();
        if (target != null && !tool.isBroken()) {
            target.f_19853_.m_46518_((Entity)target, target.m_20185_(), target.m_20186_(), target.m_20189_(), 2.0f, false, Explosion.BlockInteraction.NONE);
            if (player != null && !player.m_7500_()) {
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)10, (LivingEntity)context.getAttacker(), (InteractionHand)context.getHand());
            }
        }
        return knockback;
    }
}

