/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation;

import com.gjhi.tinkersinnovation.TinkersInnovationConfig;
import com.gjhi.tinkersinnovation.register.TinkersInnovationBlocks;
import com.gjhi.tinkersinnovation.register.TinkersInnovationCompat;
import com.gjhi.tinkersinnovation.register.TinkersInnovationEffects;
import com.gjhi.tinkersinnovation.register.TinkersInnovationEntityTypes;
import com.gjhi.tinkersinnovation.register.TinkersInnovationFluids;
import com.gjhi.tinkersinnovation.register.TinkersInnovationItems;
import com.gjhi.tinkersinnovation.register.TinkersInnovationMaterialStats;
import com.gjhi.tinkersinnovation.register.TinkersInnovationModifiers;
import com.gjhi.tinkersinnovation.register.TinkersInnovationPotions;
import com.gjhi.tinkersinnovation.register.TinkersInnovationSlots;
import com.gjhi.tinkersinnovation.register.TinkersInnovationTags;
import com.gjhi.tinkersinnovation.register.TinkersInnovationToolStats;
import com.gjhi.tinkersinnovation.register.TinkersInnovationWorldGen;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;

@Mod(value="tinkersinnovation")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TinkersInnovation {
    public static final String MOD_ID = "tinkersinnovation";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Logger tinkers_logger = LogManager.getLogger((String)"tinkersinnovation");
    public static final CreativeModeTab itemGroup = new CreativeModeTab("TinkersInnovationItemGroup"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)TinkersInnovationItems.polychrome_alloy_ingot.get());
        }
    };
    public static final CreativeModeTab toolGroup = new CreativeModeTab("TinkersInnovationToolGroup"){

        public ItemStack m_6976_() {
            return ((ModifiableItem)TinkersInnovationItems.claw.get()).getRenderTool();
        }
    };

    public static Logger getLogger() {
        return LOGGER;
    }

    public TinkersInnovation() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TinkersInnovationConfig.config);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::setup);
        bus.addListener(this::setupClient);
        TinkersInnovationModifiers.MODIFIERS.register(bus);
        TinkersInnovationBlocks.BLOCKS.register(bus);
        TinkersInnovationItems.ITEMS.register(bus);
        TinkersInnovationFluids.FLUIDS.register(bus);
        TinkersInnovationEntityTypes.ENTITY_TYPES.register(bus);
        TinkersInnovationWorldGen.CONFIGURED_FEATURES.register(bus);
        TinkersInnovationWorldGen.PLACED_FEATURES.register(bus);
        TinkersInnovationWorldGen.BLOCKS.register(bus);
        TinkersInnovationEffects.MOB_EFFECTS.register(bus);
        TinkersInnovationPotions.POTIONS.register(bus);
        TinkersInnovationTags.init();
        TinkersInnovationToolStats.init();
        TinkersInnovationSlots.init();
    }

    private void setupClient(FMLClientSetupEvent event) {
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(TinkersInnovationMaterialStats::setup);
        TinkersInnovationPotions.recipesInit();
        TinkersInnovationCompat.L2Complements.init();
        TinkersInnovationCompat.L2Hostility.init();
        TinkersInnovationCompat.IceAndFire.init();
        TinkersInnovationCompat.AlexsMobs.init();
    }

    public static ResourceLocation getResource(String id) {
        return new ResourceLocation(MOD_ID, id);
    }

    public static String makeDescriptionId(String type, String name) {
        return type + ".tinkersinnovation." + name;
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            // empty if block
        }
        if (event.includeServer()) {
            // empty if block
        }
    }
}

