/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class EntityFilter
implements Predicate<Entity> {
    private static final Pattern ELEMENT_DIVIDER = Pattern.compile(";");
    private static final Pattern ELEMENT_SUBDIVIDER = Pattern.compile("[(),]");
    private static final Map<String, Predicate<Entity>> ENTITY_PREDICATES = ImmutableMap.builder().put((Object)"mob", e -> {
        TamableAnimal t;
        return e instanceof Enemy && (!(e instanceof TamableAnimal) || !(t = (TamableAnimal)e).m_21824_());
    }).put((Object)"animal", e -> e instanceof Animal).put((Object)"living", e -> e instanceof LivingEntity).put((Object)"player", e -> e instanceof Player).put((Object)"item", e -> e instanceof ItemEntity).put((Object)"drone", e -> e instanceof DroneEntity).put((Object)"boat", e -> e instanceof Boat).put((Object)"minecart", e -> e instanceof AbstractMinecart).put((Object)"painting", e -> e instanceof Painting).put((Object)"orb", e -> e instanceof ExperienceOrb).put((Object)"nothing", e -> false).build();
    private final List<EntityMatcher> matchers = new ArrayList<EntityMatcher>();
    private final boolean sense;
    private final String rawFilter;
    private static final Set<String> DYE_COLORS = new HashSet<String>();

    public EntityFilter(String filter) {
        if (filter.startsWith("!")) {
            filter = filter.substring(1);
            this.sense = false;
        } else {
            this.sense = true;
        }
        this.rawFilter = filter;
        if (!filter.isEmpty()) {
            Arrays.stream(ELEMENT_DIVIDER.split(filter)).map(EntityMatcher::new).forEach(this.matchers::add);
        }
    }

    public static <T extends IProgWidget & IEntityProvider> EntityFilter fromProgWidget(T widget, boolean whitelist) {
        if (widget.getParameters().size() > 1) {
            int pos = ((IEntityProvider)widget).getEntityFilterPosition();
            IProgWidget w = widget.getConnectedParameters()[whitelist ? pos : widget.getParameters().size() + pos];
            if (w instanceof ProgWidgetText) {
                ArrayList<String> l = new ArrayList<String>();
                while (w instanceof ProgWidgetText) {
                    String str = ((ProgWidgetText)w).string;
                    Validate.isTrue((!str.startsWith("!") ? 1 : 0) != 0, (String)"'!' negation can't be used here (put blacklist filters on left of widget)", (Object[])new Object[0]);
                    l.add(str);
                    w = w.getConnectedParameters()[0];
                }
                return new EntityFilter(Strings.join(l, (String)";"));
            }
        }
        return whitelist ? ConstantEntityFilter.ALLOW : ConstantEntityFilter.DENY;
    }

    public static EntityFilter fromString(String s) {
        return EntityFilter.fromString(s, null);
    }

    public static EntityFilter fromString(String s, EntityFilter fallback) {
        try {
            return new EntityFilter(s);
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public static EntityFilter allow() {
        return ConstantEntityFilter.ALLOW;
    }

    public static EntityFilter deny() {
        return ConstantEntityFilter.DENY;
    }

    public String toString() {
        if (this == ConstantEntityFilter.ALLOW) {
            return "";
        }
        if (this == ConstantEntityFilter.DENY) {
            return "@nothing";
        }
        return this.sense ? this.rawFilter : "!" + this.rawFilter;
    }

    @Override
    public boolean test(Entity entity) {
        if (this.matchers.isEmpty()) {
            return true;
        }
        for (EntityMatcher m : this.matchers) {
            if (!m.test(entity)) continue;
            return this.sense;
        }
        return !this.sense;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\").append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    static {
        for (DyeColor d : DyeColor.values()) {
            DYE_COLORS.add(d.m_41065_());
        }
    }

    public static class ConstantEntityFilter
    extends EntityFilter {
        static final ConstantEntityFilter ALLOW = new ConstantEntityFilter(true);
        static final ConstantEntityFilter DENY = new ConstantEntityFilter(false);
        private final boolean allow;

        private ConstantEntityFilter(boolean allow) {
            super("");
            this.allow = allow;
        }

        @Override
        public boolean test(Entity entity) {
            return this.allow;
        }
    }

    private static class EntityMatcher
    implements Predicate<Entity> {
        private final Predicate<Entity> matcher;
        private final List<ModifierEntry> modifiers = new ArrayList<ModifierEntry>();

        private EntityMatcher(String element) {
            List<String> splits = Arrays.stream(ELEMENT_SUBDIVIDER.split(element)).map(String::trim).toList();
            String arg0 = splits.get(0);
            if (arg0.startsWith("@")) {
                String sub = arg0.substring(1);
                if (StringUtils.countMatches((CharSequence)element, (CharSequence)"(") != StringUtils.countMatches((CharSequence)element, (CharSequence)")")) {
                    throw new IllegalArgumentException("Mismatched opening/closing braces");
                }
                this.matcher = ENTITY_PREDICATES.get(sub);
                Validate.isTrue((this.matcher != null ? 1 : 0) != 0, (String)("Unknown entity type specifier: @" + sub), (Object[])new Object[0]);
            } else if (arg0.length() > 2 && (arg0.startsWith("\"") && arg0.endsWith("\"") || arg0.startsWith("'") && arg0.endsWith("'"))) {
                regex = Pattern.compile(EntityFilter.wildcardToRegex(arg0.substring(1, arg0.length() - 1)));
                this.matcher = e -> EntityMatcher.matchByName(e, regex);
            } else {
                regex = Pattern.compile(EntityFilter.wildcardToRegex(arg0), 2);
                this.matcher = e -> regex.matcher(PneumaticCraftUtils.getRegistryName(e).orElseThrow().m_135815_()).matches();
            }
            for (int i = 1; i < splits.size(); ++i) {
                String[] parts = splits.get(i).split("=");
                Validate.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)("Invalid modifier syntax: " + splits.get(i)), (Object[])new Object[0]);
                String key = parts[0];
                String arg = parts[1];
                boolean sense = true;
                if (key.endsWith("!")) {
                    key = key.substring(0, key.length() - 1);
                    sense = false;
                }
                try {
                    Modifier modifier = Modifier.valueOf(key.toUpperCase(Locale.ROOT));
                    if (!modifier.isValid(arg)) {
                        throw new IllegalArgumentException(String.format("Invalid value '%s' for modifier '%s'. Valid values: %s", arg, key, modifier.displayValidOptions()));
                    }
                    this.modifiers.add(new ModifierEntry(modifier, arg, sense));
                    continue;
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException("Unknown modifier: " + key);
                }
            }
        }

        @Override
        public boolean test(Entity entity) {
            return this.matcher.test(entity) && this.modifiers.stream().allMatch(modifierEntry -> modifierEntry.test(entity));
        }

        private static boolean matchByName(Entity entity, Pattern regex) {
            Player player;
            return entity instanceof Player ? (player = (Player)entity).m_36316_().getName() != null && regex.matcher(player.m_36316_().getName()).matches() : entity.m_7770_() != null && regex.matcher(entity.m_7770_().getString()).matches();
        }
    }

    private record ModifierEntry(Modifier modifier, String value, boolean sense) implements Predicate<Entity>
    {
        @Override
        public boolean test(Entity e) {
            return this.modifier.test(e, this.value) == this.sense;
        }
    }

    private static enum Modifier implements BiPredicate<Entity, String>
    {
        AGE((Set<String>)ImmutableSet.of((Object)"adult", (Object)"baby"), Modifier::testAge),
        AQUATIC((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), (entity, val) -> Modifier.testMobType(entity, val, MobType.f_21644_)),
        UNDEAD((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), (entity, val) -> Modifier.testMobType(entity, val, MobType.f_21641_)),
        ILLAGER((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), (entity, val) -> Modifier.testMobType(entity, val, MobType.f_21643_)),
        ARTHROPOD((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), (entity, val) -> Modifier.testMobType(entity, val, MobType.f_21642_)),
        BREEDABLE((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), Modifier::testBreedable),
        SHEARABLE((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), Modifier::testShearable),
        COLOR(DYE_COLORS, Modifier::hasColor),
        HOLDING(item -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item)), "any valid item ID, e.g. 'minecraft:cobblestone'", (entity, val) -> Modifier.isHeldItem(entity, val, true)),
        HOLDING_OFFHAND(item -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item)), "any valid item ID, e.g. 'minecraft:cobblestone'", (entity, val) -> Modifier.isHeldItem(entity, val, false)),
        MOD(str -> true, "any mod name, e.g. 'minecraft' or 'pneumaticcraft'", Modifier::testMod),
        ENTITY_TAG(str -> true, "any string tag (added to entities with the /tag command)", Modifier::testEntityTag),
        TYPE_TAG(ResourceLocation::m_135830_, "any known entity type tag, e.g 'minecraft:skeletons'", Modifier::testTypeTag),
        TEAM(str -> true, "any valid Minecraft team name", Modifier::testTeamName);

        private final Set<String> validationSet;
        private final Predicate<String> validationPredicate;
        private final String valText;
        private final BiPredicate<Entity, String> testPredicate;

        private Modifier(Predicate<String> validationPredicate, String valText, BiPredicate<Entity, String> testPredicate) {
            this.validationPredicate = validationPredicate;
            this.valText = valText;
            this.testPredicate = testPredicate;
            this.validationSet = Collections.emptySet();
        }

        private Modifier(Set<String> validationSet, BiPredicate<Entity, String> testPredicate) {
            this.validationPredicate = null;
            this.valText = "";
            this.testPredicate = testPredicate;
            this.validationSet = validationSet;
        }

        private static boolean testShearable(Entity entity, String val) {
            IForgeShearable s;
            return entity instanceof IForgeShearable && (s = (IForgeShearable)entity).isShearable(new ItemStack((ItemLike)Items.f_42574_), entity.m_20193_(), entity.m_20183_()) ? val.equalsIgnoreCase("yes") : val.equalsIgnoreCase("no");
        }

        private static boolean testBreedable(Entity entity, String val) {
            Animal a;
            return entity instanceof Animal && val.equalsIgnoreCase((a = (Animal)entity).m_146764_() == 0 ? "yes" : "no");
        }

        private static boolean testMobType(Entity entity, String val, MobType type) {
            LivingEntity l;
            return entity instanceof LivingEntity && val.equalsIgnoreCase((l = (LivingEntity)entity).m_6336_() == type ? "yes" : "no");
        }

        private static boolean testAge(Entity entity, String val) {
            AgeableMob a;
            return val.equalsIgnoreCase(entity instanceof AgeableMob && (a = (AgeableMob)entity).m_146764_() >= 0 ? "adult" : "baby");
        }

        private static boolean testMod(Entity entity, String modName) {
            ResourceLocation rl = PneumaticCraftUtils.getRegistryName(entity).orElseThrow();
            return rl.m_135827_().toLowerCase(Locale.ROOT).equals(modName.toLowerCase(Locale.ROOT));
        }

        private static boolean testEntityTag(Entity entity, String val) {
            return entity.m_19880_().contains(val);
        }

        private static boolean testTypeTag(Entity entity, String val) {
            if (!ResourceLocation.m_135830_((String)val)) {
                return false;
            }
            TagKey key = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation(val));
            return entity.m_6095_().m_204039_(key);
        }

        private static boolean testTeamName(Entity entity, String val) {
            PlayerTeam t;
            Team team = entity.m_5647_();
            return team instanceof PlayerTeam && ((t = (PlayerTeam)team).m_5758_().equalsIgnoreCase(val) || t.m_83364_().getString().equalsIgnoreCase(val));
        }

        boolean isValid(String s) {
            return this.validationPredicate == null ? this.validationSet.contains(s) : this.validationPredicate.test(s);
        }

        @Override
        public boolean test(Entity entity, String val) {
            return this.testPredicate.test(entity, val);
        }

        public String displayValidOptions() {
            return this.validationSet.isEmpty() ? this.valText : Strings.join(this.validationSet, (String)",");
        }

        private static boolean hasColor(Entity entity, String val) {
            if (entity instanceof Sheep) {
                Sheep s = (Sheep)entity;
                return s.m_29874_().m_41065_().equalsIgnoreCase(val);
            }
            if (entity instanceof Wolf) {
                Wolf w = (Wolf)entity;
                return w.m_30428_().m_41065_().equalsIgnoreCase(val);
            }
            if (entity instanceof Cat) {
                Cat c = (Cat)entity;
                return c.m_28166_().m_41065_().equalsIgnoreCase(val);
            }
            return false;
        }

        private static boolean isHeldItem(Entity entity, String name, boolean mainHand) {
            if (entity instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)entity;
                if (!((String)name).contains(":")) {
                    name = "minecraft:" + (String)name;
                }
                ItemStack stack = mainHand ? l.m_21205_() : l.m_21206_();
                return PneumaticCraftUtils.getRegistryName(stack.m_41720_()).orElseThrow().toString().equals(name);
            }
            return false;
        }
    }
}

