/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.MekanismIntegration;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.heat.ISidedHeatHandler;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class PNC2MekHeatProvider
implements ICapabilityProvider {
    private final List<LazyOptional<IHeatHandler>> handlers = new ArrayList<LazyOptional<IHeatHandler>>();
    private final WeakReference<BlockEntity> teRef;

    public PNC2MekHeatProvider(BlockEntity te) {
        this.teRef = new WeakReference<BlockEntity>(te);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional heatExchanger;
        int idx;
        BlockEntity blockEntity = (BlockEntity)this.teRef.get();
        if (cap != MekanismIntegration.CAPABILITY_HEAT_HANDLER || blockEntity == null || !blockEntity.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side).isPresent()) {
            return LazyOptional.empty();
        }
        if (this.handlers.isEmpty()) {
            for (int i = 0; i < 7; ++i) {
                this.handlers.add((LazyOptional<IHeatHandler>)LazyOptional.empty());
            }
        }
        int n = idx = side == null ? 6 : side.m_122411_();
        if (!this.handlers.get(idx).isPresent() && (heatExchanger = blockEntity.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side)).isPresent()) {
            heatExchanger.addListener(l -> this.handlers.set(idx, (LazyOptional<IHeatHandler>)LazyOptional.empty()));
            PNC2MekHeatAdapter adapter = new PNC2MekHeatAdapter(side, (LazyOptional<IHeatExchangerLogic>)heatExchanger);
            this.handlers.set(idx, (LazyOptional<IHeatHandler>)LazyOptional.of(() -> adapter));
        }
        return this.handlers.get(idx);
    }

    public record PNC2MekHeatAdapter(Direction side, LazyOptional<IHeatExchangerLogic> heatExchanger) implements ISidedHeatHandler
    {
        @Nullable
        public Direction getHeatSideFor() {
            return this.side;
        }

        public int getHeatCapacitorCount(@Nullable Direction direction) {
            return this.heatExchanger.isPresent() ? 1 : 0;
        }

        public double getTemperature(int i, @Nullable Direction direction) {
            return this.heatExchanger.map(IHeatExchangerLogic::getTemperature).orElse(0.0);
        }

        public double getInverseConduction(int i, @Nullable Direction direction) {
            return this.heatExchanger.map(h -> h.getThermalResistance() * (Double)ConfigHelper.common().integration.mekThermalResistanceFactor.get()).orElse(1.0);
        }

        public double getHeatCapacity(int i, @Nullable Direction direction) {
            return this.heatExchanger.map(IHeatExchangerLogic::getThermalCapacity).orElse(0.0);
        }

        public void handleHeat(int i, double amount, @Nullable Direction direction) {
            this.heatExchanger.ifPresent(h -> h.addHeat(amount * (Double)ConfigHelper.common().integration.mekThermalEfficiencyFactor.get()));
        }
    }
}

