/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class ThermoPlantRecipeImpl
extends ThermoPlantRecipe {
    private final FluidIngredient inputFluid;
    private final FluidStack outputFluid;
    private final Ingredient inputItem;
    private final float requiredPressure;
    private final float recipeSpeed;
    private final boolean exothermic;
    private final TemperatureRange operatingTemperature;
    private final ItemStack outputItem;
    private final float airUseMultiplier;

    public ThermoPlantRecipeImpl(ResourceLocation id, @Nonnull FluidIngredient inputFluid, @Nonnull Ingredient inputItem, FluidStack outputFluid, ItemStack outputItem, TemperatureRange operatingTemperature, float requiredPressure, float recipeSpeed, float airUseMultiplier, boolean exothermic) {
        super(id);
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.operatingTemperature = operatingTemperature;
        this.requiredPressure = requiredPressure;
        this.recipeSpeed = recipeSpeed;
        this.airUseMultiplier = airUseMultiplier;
        this.exothermic = exothermic;
    }

    @Override
    public boolean matches(FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        return (this.inputFluid.m_43947_() && fluidStack.isEmpty() || this.inputFluid.testFluid(fluidStack.getFluid())) && (this.inputItem.m_43947_() && itemStack.m_41619_() || this.inputItem.test(itemStack));
    }

    @Override
    public TemperatureRange getOperatingTemperature() {
        return this.operatingTemperature;
    }

    @Override
    public float getRequiredPressure() {
        return this.requiredPressure;
    }

    @Override
    public FluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    @Override
    @Nonnull
    public Ingredient getInputItem() {
        return this.inputItem;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public boolean isExothermic() {
        return this.exothermic;
    }

    @Override
    public float getRecipeSpeed() {
        return this.recipeSpeed;
    }

    @Override
    public float getAirUseMultiplier() {
        return this.airUseMultiplier;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.operatingTemperature.write(buffer);
        buffer.writeFloat(this.requiredPressure);
        this.inputItem.m_43923_(buffer);
        this.inputFluid.m_43923_(buffer);
        this.outputFluid.writeToPacket(buffer);
        buffer.m_130055_(this.outputItem);
        buffer.writeFloat(this.recipeSpeed);
        buffer.writeFloat(this.airUseMultiplier);
        buffer.writeBoolean(this.exothermic);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.THERMO_PLANT.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.THERMO_PLANT.get();
    }

    public String m_6076_() {
        return "pneumaticcraft:thermo_plant";
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get());
    }

    public static class Serializer<T extends ThermoPlantRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            if (!json.has("item_input") && !json.has("fluid_input")) {
                throw new JsonSyntaxException("Must have at least one of item_input and/or fluid_input!");
            }
            if (!json.has("item_output") && !json.has("fluid_output")) {
                throw new JsonSyntaxException("Must have at least one of item_output and/or fluid_output!");
            }
            Ingredient itemInput = json.has("item_input") ? Ingredient.m_43917_((JsonElement)json.get("item_input")) : Ingredient.f_43901_;
            FluidIngredient fluidInput = json.has("fluid_input") ? FluidIngredient.m_43917_((JsonElement)json.get("fluid_input")) : FluidIngredient.EMPTY;
            FluidStack fluidOutput = json.has("fluid_output") ? ModCraftingHelper.fluidStackFromJson(json.getAsJsonObject("fluid_output")) : FluidStack.EMPTY;
            ItemStack itemOutput = json.has("item_output") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"item_output")) : ItemStack.f_41583_;
            TemperatureRange range = json.has("temperature") ? TemperatureRange.fromJson(json.getAsJsonObject("temperature")) : TemperatureRange.any();
            float pressure = GsonHelper.m_13820_((JsonObject)json, (String)"pressure", (float)0.0f);
            boolean exothermic = GsonHelper.m_13855_((JsonObject)json, (String)"exothermic", (boolean)false);
            float recipeSpeed = GsonHelper.m_13820_((JsonObject)json, (String)"speed", (float)1.0f);
            float airUseMultiplier = GsonHelper.m_13820_((JsonObject)json, (String)"air_use_multiplier", (float)1.0f);
            return this.factory.create(recipeId, fluidInput, itemInput, fluidOutput, itemOutput, range, pressure, recipeSpeed, airUseMultiplier, exothermic);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            TemperatureRange range = TemperatureRange.read(buffer);
            float pressure = buffer.readFloat();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidIngredient fluidIn = (FluidIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack fluidOut = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            ItemStack itemOutput = buffer.m_130267_();
            float recipeSpeed = buffer.readFloat();
            float airUseMultiplier = buffer.readFloat();
            boolean exothermic = buffer.readBoolean();
            return this.factory.create(recipeId, fluidIn, input, fluidOut, itemOutput, range, pressure, recipeSpeed, airUseMultiplier, exothermic);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends ThermoPlantRecipe> {
            public T create(ResourceLocation var1, @Nonnull FluidIngredient var2, @Nonnull Ingredient var3, FluidStack var4, ItemStack var5, TemperatureRange var6, float var7, float var8, float var9, boolean var10);
        }
    }
}

