/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;

public class PressureDisenchantingRecipe
extends PressureChamberRecipeImpl {
    public static final ResourceLocation ID = PneumaticRegistry.RL("pressure_chamber_disenchanting");

    public PressureDisenchantingRecipe(ResourceLocation id) {
        super(id, Collections.emptyList(), -0.75f, new ItemStack[0]);
    }

    @Override
    public Collection<Integer> findIngredients(@Nonnull IItemHandler chamberHandler) {
        int bookSlot = -1;
        int itemSlot = -1;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack stack = chamberHandler.getStackInSlot(i);
            if (stack.m_41720_() == Items.f_42517_) {
                bookSlot = i;
            } else {
                int minEnchantments;
                int n = minEnchantments = stack.m_41720_() == Items.f_42690_ ? 2 : 1;
                if (!this.blacklisted(stack) && EnchantmentHelper.m_44831_((ItemStack)stack).size() >= minEnchantments) {
                    itemSlot = i;
                }
            }
            if (bookSlot < 0 || itemSlot < 0) continue;
            return ImmutableList.of((Object)bookSlot, (Object)itemSlot);
        }
        return Collections.emptyList();
    }

    @Override
    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, List<Integer> ingredientSlots, boolean simulate) {
        ItemStack book = chamberHandler.extractItem(ingredientSlots.get(0).intValue(), 1, simulate);
        ItemStack enchantedStack = chamberHandler.extractItem(ingredientSlots.get(1).intValue(), 1, simulate);
        if (book.m_41619_() || enchantedStack.m_41619_()) {
            return NonNullList.m_122779_();
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)enchantedStack);
        ArrayList l = new ArrayList(enchantments.keySet());
        Enchantment strippedEnchantment = (Enchantment)l.get(ThreadLocalRandom.current().nextInt(l.size()));
        int level = (Integer)enchantments.get(strippedEnchantment);
        enchantments.remove(strippedEnchantment);
        if (enchantedStack.m_41720_() == Items.f_42690_) {
            enchantedStack = new ItemStack((ItemLike)Items.f_42690_);
        }
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)enchantedStack);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)strippedEnchantment, (Object)level), (ItemStack)enchantedBook);
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{enchantedBook, enchantedStack});
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
        pick.m_41663_(Enchantments.f_44987_, 1);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        enchantedBook.m_41663_(Enchantments.f_44987_, 1);
        enchantedBook.m_41663_(Enchantments.f_44984_, 1);
        return ImmutableList.of((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{pick, enchantedBook}), (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42517_}));
    }

    @Override
    public List<List<ItemStack>> getResultsForDisplay() {
        ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        enchantedBook.m_41663_(Enchantments.f_44984_, 1);
        ItemStack resultBook = new ItemStack((ItemLike)Items.f_42690_);
        resultBook.m_41663_(Enchantments.f_44987_, 1);
        return ImmutableList.of((Object)ImmutableList.of((Object)pick, (Object)enchantedBook), (Object)ImmutableList.of((Object)resultBook));
    }

    @Override
    public List<Set<PressureChamberRecipe.RecipeSlot>> getSyncGroupsForDisplay() {
        return ImmutableList.of((Object)ImmutableSet.of((Object)new PressureChamberRecipe.RecipeSlot(true, 0), (Object)new PressureChamberRecipe.RecipeSlot(false, 0)));
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.m_41720_() == Items.f_42517_ || stack.m_41720_() != Items.f_42690_ && EnchantmentHelper.m_44831_((ItemStack)stack).size() > 0;
    }

    @Override
    public String getTooltipKey(boolean input, String slotName) {
        return switch (slotName) {
            case "in0" -> "pneumaticcraft.gui.nei.tooltip.vacuumEnchantItem";
            case "out0" -> "pneumaticcraft.gui.nei.tooltip.vacuumEnchantItemOut";
            case "out1" -> "pneumaticcraft.gui.nei.tooltip.vacuumEnchantBookOut";
            default -> "";
        };
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.PRESSURE_CHAMBER_DISENCHANTING.get();
    }

    private boolean blacklisted(ItemStack stack) {
        List blackList = (List)ConfigHelper.common().machines.disenchantingBlacklist.get();
        return PneumaticCraftUtils.getRegistryName(stack.m_41720_()).map(name -> blackList.stream().anyMatch(element -> element.startsWith(name.toString()))).orElse(false);
    }
}

