/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.UUID;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;

public class ReachDistanceHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final UUID REACH_DIST_BOOST_ID = UUID.fromString("c9dce729-70c4-4c0f-95d4-31d2e50bc826");
    public static final AttributeModifier REACH_DIST_BOOST = new AttributeModifier(REACH_DIST_BOOST_ID, "Pneumatic Reach Boost", 3.5, AttributeModifier.Operation.ADDITION);
    private static final ResourceLocation ID = PneumaticRegistry.RL("reach_distance");

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{(PNCUpgrade)ModUpgrades.RANGE.get()};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 5.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        AttributeInstance attr;
        Player player = commonArmorHandler.getPlayer();
        if ((player.f_19853_.m_46467_() & 0xFL) == 0L && (attr = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            attr.m_22130_(REACH_DIST_BOOST);
            if (enabled && commonArmorHandler.hasMinPressure(EquipmentSlot.CHEST) && commonArmorHandler.isArmorEnabled()) {
                attr.m_22118_(REACH_DIST_BOOST);
            }
        }
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        AttributeInstance attr;
        if (!newState && (attr = commonArmorHandler.getPlayer().m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            attr.m_22130_(REACH_DIST_BOOST);
        }
    }

    @Override
    public void onShutdown(ICommonArmorHandler commonArmorHandler) {
        AttributeInstance attr = commonArmorHandler.getPlayer().m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (attr != null) {
            attr.m_22130_(REACH_DIST_BOOST);
        }
    }
}

