/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.lang.reflect.Field;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SyncedField<T> {
    private final Field field;
    private final Object te;
    private T lastValue;
    private int arrayIndex = -1;
    private boolean isLazy;

    SyncedField(Object te, Field field) {
        this.field = field;
        field.setAccessible(true);
        this.te = te;
    }

    SyncedField<T> setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
        return this;
    }

    public SyncedField<T> setLazy(boolean lazy) {
        this.isLazy = lazy;
        return this;
    }

    public String toString() {
        return this.arrayIndex == -1 ? "[" + this.te + "/" + this.field.getName() + "=" + this.getValue() + "]" : "[" + this.te + "/" + this.field.getName() + "[" + this.arrayIndex + "]=" + this.getValue() + "]";
    }

    public boolean update() {
        try {
            T value;
            T t = value = this.arrayIndex >= 0 ? this.getValueForArray(this.field.get(this.te), this.arrayIndex) : this.retrieveValue(this.field, this.te);
            if (this.lastValue == null && value != null || this.lastValue != null && !this.equals(this.lastValue, value)) {
                this.lastValue = value == null ? null : this.copyWhenNecessary(value);
                return !this.isLazy;
            }
        }
        catch (Throwable e) {
            Log.error("A problem occurred when trying to sync the field of " + this.te.toString() + ". Field: " + this.field.toString(), new Object[0]);
            e.printStackTrace();
        }
        return false;
    }

    protected boolean equals(T oldValue, T newValue) {
        return oldValue.equals(newValue);
    }

    protected T copyWhenNecessary(T oldValue) {
        return oldValue;
    }

    protected T retrieveValue(Field field, Object te) throws Exception {
        return (T)field.get(te);
    }

    protected void injectValue(Field field, Object te, T value) throws Exception {
        field.set(te, value);
    }

    protected abstract T getValueForArray(Object var1, int var2);

    protected abstract void setValueForArray(Object var1, int var2, T var3);

    public T getValue() {
        return this.lastValue;
    }

    private void setValueInternal(T value) {
        try {
            if (this.arrayIndex >= 0) {
                this.setValueForArray(this.field.get(this.te), this.arrayIndex, value);
            } else {
                this.injectValue(this.field, this.te, value);
            }
        }
        catch (Exception e) {
            Log.error("A problem occurred when trying to sync the field of " + this.te.toString() + ". Field: " + this.field.toString(), new Object[0]);
            e.printStackTrace();
        }
    }

    public void setValue(Object value) {
        this.setValueInternal(value);
    }

    public static byte getType(SyncedField<?> syncedField) {
        if (syncedField instanceof SyncedInt) {
            return 0;
        }
        if (syncedField instanceof SyncedFloat) {
            return 1;
        }
        if (syncedField instanceof SyncedDouble) {
            return 2;
        }
        if (syncedField instanceof SyncedBoolean) {
            return 3;
        }
        if (syncedField instanceof SyncedString) {
            return 4;
        }
        if (syncedField instanceof SyncedEnum) {
            return 5;
        }
        if (syncedField instanceof SyncedItemStack) {
            return 6;
        }
        if (syncedField instanceof SyncedFluidStack) {
            return 7;
        }
        if (syncedField instanceof SyncedItemHandler) {
            return 8;
        }
        throw new IllegalArgumentException("Invalid sync type! " + syncedField);
    }

    static Object fromBytes(FriendlyByteBuf buf, int type) {
        switch (type) {
            case 0: {
                return buf.readInt();
            }
            case 1: {
                return Float.valueOf(buf.readFloat());
            }
            case 2: {
                return buf.readDouble();
            }
            case 3: {
                return buf.readBoolean();
            }
            case 4: {
                return buf.m_130277_();
            }
            case 5: {
                return buf.readByte();
            }
            case 6: {
                return buf.m_130267_();
            }
            case 7: {
                return buf.readFluidStack();
            }
            case 8: {
                int len = buf.m_130242_();
                ItemStackHandler handler = new ItemStackHandler(len);
                for (int i = 0; i < len; ++i) {
                    handler.setStackInSlot(buf.m_130242_(), buf.m_130267_());
                }
                return handler;
            }
        }
        throw new IllegalArgumentException("Invalid sync type! " + type);
    }

    static void toBytes(FriendlyByteBuf buf, Object value, int type) {
        switch (type) {
            case 0: {
                buf.writeInt(((Integer)value).intValue());
                break;
            }
            case 1: {
                buf.writeFloat(((Float)value).floatValue());
                break;
            }
            case 2: {
                buf.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 3: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 4: {
                buf.m_130070_((String)value);
                break;
            }
            case 5: {
                buf.writeByte((int)((Byte)value).byteValue());
                break;
            }
            case 6: {
                buf.m_130055_(value == null ? ItemStack.f_41583_ : (ItemStack)value);
                break;
            }
            case 7: {
                buf.writeFluidStack((FluidStack)value);
                break;
            }
            case 8: {
                ItemStackHandler h = (ItemStackHandler)value;
                buf.m_130130_(h.getSlots());
                for (int i = 0; i < h.getSlots(); ++i) {
                    buf.m_130130_(i);
                    buf.m_130055_(h.getStackInSlot(i));
                }
                break;
            }
        }
    }

    public static class SyncedInt
    extends SyncedField<Integer> {
        public SyncedInt(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Integer getValueForArray(Object array, int index) {
            return ((int[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Integer value) {
            ((int[])array)[index] = value;
        }
    }

    public static class SyncedFloat
    extends SyncedField<Float> {
        SyncedFloat(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Float getValueForArray(Object array, int index) {
            return Float.valueOf(((float[])array)[index]);
        }

        @Override
        protected void setValueForArray(Object array, int index, Float value) {
            ((float[])array)[index] = value.floatValue();
        }
    }

    public static class SyncedDouble
    extends SyncedField<Double> {
        SyncedDouble(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Double getValueForArray(Object array, int index) {
            return ((double[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Double value) {
            ((double[])array)[index] = value;
        }
    }

    public static class SyncedBoolean
    extends SyncedField<Boolean> {
        SyncedBoolean(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Boolean getValueForArray(Object array, int index) {
            return ((boolean[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Boolean value) {
            ((boolean[])array)[index] = value;
        }
    }

    public static class SyncedString
    extends SyncedField<String> {
        SyncedString(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected String getValueForArray(Object array, int index) {
            return ((String[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, String value) {
            ((String[])array)[index] = value;
        }
    }

    public static class SyncedEnum
    extends SyncedField<Byte> {
        SyncedEnum(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Byte getValueForArray(Object array, int index) {
            return ((byte[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Byte value) {
            ((byte[])array)[index] = value;
        }

        @Override
        protected Byte retrieveValue(Field field, Object te) throws Exception {
            Object[] enumTypes = field.getType().getEnumConstants();
            return (byte)ArrayUtils.indexOf((Object[])enumTypes, (Object)field.get(te));
        }

        @Override
        protected void injectValue(Field field, Object te, Byte value) throws Exception {
            if (value == -1) {
                field.set(te, null);
            } else {
                Object enumType = field.getType().getEnumConstants()[value];
                field.set(te, enumType);
            }
        }
    }

    public static class SyncedItemStack
    extends SyncedField<ItemStack> {
        SyncedItemStack(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected ItemStack getValueForArray(Object array, int index) {
            return ((ItemStack[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, ItemStack value) {
            ((ItemStack[])array)[index] = value;
        }
    }

    public static class SyncedFluidStack
    extends SyncedField<FluidStack> {
        SyncedFluidStack(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected FluidStack getValueForArray(Object array, int index) {
            return ((FluidStack[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, FluidStack value) {
            ((FluidStack[])array)[index] = value;
        }

        @Override
        protected boolean equals(FluidStack oldValue, FluidStack newValue) {
            return oldValue.isFluidStackIdentical(newValue);
        }
    }

    public static class SyncedItemHandler
    extends SyncedField<IItemHandlerModifiable> {
        SyncedItemHandler(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected ItemStackHandler getValueForArray(Object array, int index) {
            return ((ItemStackHandler[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, IItemHandlerModifiable value) {
            ((IItemHandlerModifiable[])array)[index] = value;
        }

        @Override
        protected IItemHandlerModifiable retrieveValue(Field field, Object te) throws Exception {
            return (IItemHandlerModifiable)field.get(te);
        }

        @Override
        protected void injectValue(Field field, Object te, IItemHandlerModifiable value) throws Exception {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)field.get(te);
            for (int i = 0; i < value.getSlots(); ++i) {
                handler.setStackInSlot(i, value.getStackInSlot(i));
            }
        }

        @Override
        protected boolean equals(IItemHandlerModifiable oldValue, IItemHandlerModifiable newValue) {
            if (oldValue.getSlots() != newValue.getSlots()) {
                return false;
            }
            for (int i = 0; i < oldValue.getSlots(); ++i) {
                if (ItemStack.m_41728_((ItemStack)oldValue.getStackInSlot(i), (ItemStack)newValue.getStackInSlot(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected IItemHandlerModifiable copyWhenNecessary(IItemHandlerModifiable oldValue) {
            ItemStackHandler result = new ItemStackHandler(oldValue.getSlots());
            for (int i = 0; i < oldValue.getSlots(); ++i) {
                ItemStack stack = oldValue.getStackInSlot(i);
                result.setStackInSlot(i, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
            }
            return result;
        }
    }
}

