/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.ThermostatModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncThermostatModuleToClient
extends LocationIntPacket {
    private final Direction side;
    private final int channel;
    private final int level;
    private final int temperature;

    public PacketSyncThermostatModuleToClient(ThermostatModule module) {
        super(module.getTube().m_58899_());
        this.channel = module.getColorChannel();
        this.side = module.getDirection();
        this.level = module.getLevel();
        this.temperature = module.getTemperature();
    }

    PacketSyncThermostatModuleToClient(FriendlyByteBuf buffer) {
        super(buffer);
        this.channel = buffer.readByte();
        this.side = (Direction)buffer.m_130066_(Direction.class);
        this.level = buffer.readInt();
        this.temperature = buffer.readInt();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.channel);
        buf.m_130068_((Enum)this.side);
        buf.writeInt(this.level);
        buf.writeInt(this.temperature);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PneumaticCraftUtils.getTileEntityAt((BlockGetter)ClientUtils.getClientLevel(), this.pos, PressureTubeBlockEntity.class).ifPresent(te -> {
            AbstractTubeModule patt2602$temp = te.getModule(this.side);
            if (patt2602$temp instanceof ThermostatModule) {
                ThermostatModule mr = (ThermostatModule)patt2602$temp;
                mr.setColorChannel(this.channel);
                mr.setLevel(this.level);
                mr.setTemperature(this.temperature);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

