/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.Collection;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractSemiblockEntity
extends Entity
implements ISemiBlock,
IGUIButtonSensitive {
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(AbstractSemiblockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.m_135353_(AbstractSemiblockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final float MAX_HEALTH = 40.0f;
    private BlockEntity cachedTE;
    private boolean beingRemoved = false;
    private AABB blockBounds;
    private BlockPos blockPos;
    private Vec3 dropOffset = Vec3.f_82478_;
    private Block lastBlock;

    AbstractSemiblockEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    private void dropItem(ItemStack stack) {
        if (!stack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_() + this.dropOffset.m_7096_(), this.m_20186_() + this.dropOffset.m_7098_(), this.m_20189_() + this.dropOffset.m_7094_(), stack);
            itemEntity.m_32060_();
            Collection capture = this.captureDrops();
            if (capture != null) {
                capture.add(itemEntity);
            } else {
                this.f_19853_.m_7967_((Entity)itemEntity);
            }
        }
    }

    @Override
    public Component getSemiblockDisplayName() {
        return new ItemStack((ItemLike)this.getDroppedItem()).m_41611_();
    }

    public void m_8119_() {
        Block curBlock;
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.m_20011_(this.getBlockBounds().m_82338_(this.blockPos));
            this.lastBlock = this.getBlockState().m_60734_();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.canStay()) {
            this.beingRemoved = true;
            this.m_6074_();
        }
        if ((curBlock = this.getBlockState().m_60734_()) != this.lastBlock) {
            this.cachedTE = null;
            this.blockBounds = null;
            this.lastBlock = curBlock;
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 hitVec, InteractionHand hand) {
        InteractionResult res;
        Vec3 end;
        Vec3 eye = player.m_20299_(0.0f);
        ClipContext ctx = new ClipContext(eye, end = eye.m_82549_(player.m_20154_().m_82541_().m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult brtr = player.f_19853_.m_45547_(ctx);
        if (brtr.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (player.m_21120_(hand).m_41720_() == ModItems.LOGISTICS_CONFIGURATOR.get() && !player.f_19853_.f_46443_) {
            if (player.m_6144_()) {
                this.killedByEntity((Entity)player);
                return InteractionResult.SUCCESS;
            }
            if (this.onRightClickWithConfigurator(player, brtr.m_82434_())) {
                player.m_21120_(hand).getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> h.addAir(-50));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        UseOnContext itemCtx = new UseOnContext(player, hand, brtr);
        InteractionResult interactionResult = res = player.m_6144_() ? InteractionResult.PASS : this.getBlockState().m_60664_(this.f_19853_, player, hand, brtr);
        if (res.m_19077_() || res == InteractionResult.FAIL) {
            return res;
        }
        res = player.m_21120_(hand).onItemUseFirst(itemCtx);
        return res == InteractionResult.PASS ? player.m_21120_(hand).m_41661_(itemCtx) : res;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIME_SINCE_HIT, (Object)0);
        this.f_19804_.m_135372_(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    @Override
    public Level getWorld() {
        return this.f_19853_;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void m_6034_(double x, double y, double z) {
        if (!this.isAddedToWorld()) {
            super.m_6034_(x, y, z);
            this.blockPos = new BlockPos(x, y, z);
        }
    }

    public BlockState getBlockState() {
        return this.f_19853_.m_8055_(this.blockPos);
    }

    @Override
    public BlockEntity getCachedTileEntity() {
        if (!this.f_19853_.m_46749_(this.blockPos)) {
            return null;
        }
        if (this.cachedTE == null || this.cachedTE.m_58901_()) {
            this.cachedTE = this.f_19853_.m_7702_(this.blockPos);
        }
        return this.cachedTE;
    }

    protected Item getDroppedItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.getSemiblockId());
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.m_122779_();
        Item item = this.getDroppedItem();
        if (item != null) {
            ItemStack stack = new ItemStack((ItemLike)this.getDroppedItem());
            CompoundTag tag = new CompoundTag();
            this.serializeNBT(tag);
            if (!tag.m_128456_()) {
                stack.m_41784_().m_128365_("EntityTag", (Tag)tag);
            }
            drops.add((Object)stack);
        }
        return drops;
    }

    public final AABB getBlockBounds() {
        if (this.blockBounds == null) {
            this.blockBounds = this.calculateBlockBounds();
        }
        return this.blockBounds;
    }

    protected AABB calculateBlockBounds() {
        VoxelShape shape;
        AABB aabb = this.f_19853_ != null ? ((shape = this.f_19853_.m_8055_(this.blockPos).m_60808_((BlockGetter)this.f_19853_, this.blockPos)).m_83281_() ? Shapes.m_83144_().m_83215_() : shape.m_83215_()) : Shapes.m_83144_().m_83215_();
        return aabb;
    }

    public boolean canStay() {
        return this.canPlace(null);
    }

    @Override
    public ResourceLocation getSemiblockId() {
        return PneumaticCraftUtils.getRegistryName(ForgeRegistries.ENTITY_TYPES, this.m_6095_()).orElseThrow();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag) {
        return tag;
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
        this.serializeNBT(compound);
    }

    @Override
    public boolean isValid() {
        return this.m_6084_();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.f_19853_.f_46443_) {
            if (SemiblockTracker.getInstance().putSemiblock(this.f_19853_, this.blockPos, this)) {
                MinecraftForge.EVENT_BUS.post((Event)new SemiblockEvent.PlaceEvent(this.f_19853_, this.blockPos, this));
                this.f_19853_.markAndNotifyBlock(this.blockPos, this.f_19853_.m_46745_(this.blockPos), this.getBlockState(), this.getBlockState(), 3, 512);
            } else {
                Direction direction;
                AbstractSemiblockEntity abstractSemiblockEntity = this;
                if (abstractSemiblockEntity instanceof IDirectionalSemiblock) {
                    IDirectionalSemiblock d = (IDirectionalSemiblock)((Object)abstractSemiblockEntity);
                    direction = d.getSide();
                } else {
                    direction = null;
                }
                Direction dir = direction;
                Log.error("SemiblockTracker: not overwriting existing semiblock at %s, pos=%s, dir=%s!", this.f_19853_, this.blockPos, dir);
            }
        }
    }

    public void onRemovedFromWorld() {
        if (!this.f_19853_.f_46443_) {
            Direction direction;
            AbstractSemiblockEntity abstractSemiblockEntity = this;
            if (abstractSemiblockEntity instanceof IDirectionalSemiblock) {
                IDirectionalSemiblock d = (IDirectionalSemiblock)((Object)abstractSemiblockEntity);
                direction = d.getSide();
            } else {
                direction = null;
            }
            Direction dir = direction;
            SemiblockTracker.getInstance().clearSemiblock(this.f_19853_, this.blockPos, dir);
            MinecraftForge.EVENT_BUS.post((Event)new SemiblockEvent.BreakEvent(this.f_19853_, this.blockPos, this));
            if (this.beingRemoved) {
                this.getDrops().forEach(this::dropItem);
            }
            if (this.f_19853_.m_46749_(this.blockPos)) {
                this.f_19853_.markAndNotifyBlock(this.blockPos, this.f_19853_.m_46745_(this.blockPos), this.getBlockState(), this.getBlockState(), 3, 512);
            }
        }
        this.doExtraCleanupTasks(this.beingRemoved);
        super.onRemovedFromWorld();
    }

    protected void doExtraCleanupTasks(boolean removingSemiblock) {
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    @Override
    public int getTrackingId() {
        return this.isAddedToWorld() ? this.m_19879_() : -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canCoexist(ISemiBlock otherSemiblock) {
        AbstractSemiblockEntity abstractSemiblockEntity = this;
        if (!(abstractSemiblockEntity instanceof IDirectionalSemiblock)) return otherSemiblock instanceof IDirectionalSemiblock;
        IDirectionalSemiblock d1 = (IDirectionalSemiblock)((Object)abstractSemiblockEntity);
        if (!(otherSemiblock instanceof IDirectionalSemiblock)) return true;
        IDirectionalSemiblock d2 = (IDirectionalSemiblock)((Object)otherSemiblock);
        if (d1.getSide() == d2.getSide()) return false;
        return true;
    }

    @Override
    public void killedByEntity(Entity entity) {
        entity.f_19853_.m_5594_(null, this.blockPos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.dropOffset = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        this.beingRemoved = true;
        this.m_6074_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || !(source.m_7640_() instanceof Player)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            if (this.getDamageTaken() > 40.0f) {
                if (source.m_7639_() != null) {
                    this.killedByEntity(source.m_7639_());
                } else {
                    this.m_6074_();
                }
            }
        }
        return true;
    }

    private void setDamageTaken(float damageTaken) {
        this.f_19804_.m_135381_(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE_TAKEN)).floatValue();
    }

    private void setTimeSinceHit(int timeSinceHit) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }

    public boolean isAir() {
        return this.getBlockState().m_60795_();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
    }

    @Override
    public void writeToBuf(FriendlyByteBuf payload) {
    }

    @Override
    public void readFromBuf(FriendlyByteBuf payload) {
    }
}

