/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class ModUpgrades {
    public static final DeferredRegister<PNCUpgrade> UPGRADES_DEFERRED = DeferredRegister.create((ResourceLocation)PneumaticRegistry.RL("upgrades"), (String)"pneumaticcraft");
    public static final Supplier<IForgeRegistry<PNCUpgrade>> UPGRADES = UPGRADES_DEFERRED.makeRegistry(() -> new RegistryBuilder().disableSaving().disableSync());
    public static final RegistryObject<PNCUpgrade> VOLUME = ModUpgrades.register(BuiltinUpgrade.VOLUME);
    public static final RegistryObject<PNCUpgrade> DISPENSER = ModUpgrades.register(BuiltinUpgrade.DISPENSER);
    public static final RegistryObject<PNCUpgrade> ITEM_LIFE = ModUpgrades.register(BuiltinUpgrade.ITEM_LIFE);
    public static final RegistryObject<PNCUpgrade> ENTITY_TRACKER = ModUpgrades.register(BuiltinUpgrade.ENTITY_TRACKER);
    public static final RegistryObject<PNCUpgrade> BLOCK_TRACKER = ModUpgrades.register(BuiltinUpgrade.BLOCK_TRACKER);
    public static final RegistryObject<PNCUpgrade> SPEED = ModUpgrades.register(BuiltinUpgrade.SPEED);
    public static final RegistryObject<PNCUpgrade> SEARCH = ModUpgrades.register(BuiltinUpgrade.SEARCH);
    public static final RegistryObject<PNCUpgrade> COORDINATE_TRACKER = ModUpgrades.register(BuiltinUpgrade.COORDINATE_TRACKER);
    public static final RegistryObject<PNCUpgrade> RANGE = ModUpgrades.register(BuiltinUpgrade.RANGE);
    public static final RegistryObject<PNCUpgrade> SECURITY = ModUpgrades.register(BuiltinUpgrade.SECURITY);
    public static final RegistryObject<PNCUpgrade> MAGNET = ModUpgrades.register(BuiltinUpgrade.MAGNET);
    public static final RegistryObject<PNCUpgrade> THAUMCRAFT = ModUpgrades.register(BuiltinUpgrade.THAUMCRAFT);
    public static final RegistryObject<PNCUpgrade> CHARGING = ModUpgrades.register(BuiltinUpgrade.CHARGING);
    public static final RegistryObject<PNCUpgrade> ARMOR = ModUpgrades.register(BuiltinUpgrade.ARMOR);
    public static final RegistryObject<PNCUpgrade> JET_BOOTS = ModUpgrades.register(BuiltinUpgrade.JET_BOOTS);
    public static final RegistryObject<PNCUpgrade> NIGHT_VISION = ModUpgrades.register(BuiltinUpgrade.NIGHT_VISION);
    public static final RegistryObject<PNCUpgrade> SCUBA = ModUpgrades.register(BuiltinUpgrade.SCUBA);
    public static final RegistryObject<PNCUpgrade> CREATIVE = ModUpgrades.register(BuiltinUpgrade.CREATIVE);
    public static final RegistryObject<PNCUpgrade> AIR_CONDITIONING = ModUpgrades.register(BuiltinUpgrade.AIR_CONDITIONING);
    public static final RegistryObject<PNCUpgrade> INVENTORY = ModUpgrades.register(BuiltinUpgrade.INVENTORY);
    public static final RegistryObject<PNCUpgrade> JUMPING = ModUpgrades.register(BuiltinUpgrade.JUMPING);
    public static final RegistryObject<PNCUpgrade> FLIPPERS = ModUpgrades.register(BuiltinUpgrade.FLIPPERS);
    public static final RegistryObject<PNCUpgrade> STANDBY = ModUpgrades.register(BuiltinUpgrade.STANDBY);
    public static final RegistryObject<PNCUpgrade> MINIGUN = ModUpgrades.register(BuiltinUpgrade.MINIGUN);
    public static final RegistryObject<PNCUpgrade> RADIATION_SHIELDING = ModUpgrades.register(BuiltinUpgrade.RADIATION_SHIELDING);
    public static final RegistryObject<PNCUpgrade> GILDED = ModUpgrades.register(BuiltinUpgrade.GILDED);
    public static final RegistryObject<PNCUpgrade> ENDER_VISOR = ModUpgrades.register(BuiltinUpgrade.ENDER_VISOR);
    public static final RegistryObject<PNCUpgrade> STOMP = ModUpgrades.register(BuiltinUpgrade.STOMP);
    public static final RegistryObject<PNCUpgrade> ELYTRA = ModUpgrades.register(BuiltinUpgrade.ELYTRA);
    public static final RegistryObject<PNCUpgrade> CHUNKLOADER = ModUpgrades.register(BuiltinUpgrade.CHUNKLOADER);

    private static RegistryObject<PNCUpgrade> register(BuiltinUpgrade upgrade) {
        return UPGRADES_DEFERRED.register(upgrade.name, () -> new PNCUpgrade(upgrade.maxTier, upgrade.depModIds));
    }

    static enum BuiltinUpgrade {
        VOLUME("volume"),
        DISPENSER("dispenser"),
        ITEM_LIFE("item_life"),
        ENTITY_TRACKER("entity_tracker"),
        BLOCK_TRACKER("block_tracker"),
        SPEED("speed"),
        SEARCH("search"),
        COORDINATE_TRACKER("coordinate_tracker"),
        RANGE("range"),
        SECURITY("security"),
        MAGNET("magnet"),
        THAUMCRAFT("thaumcraft", 1, "thaumcraft"),
        CHARGING("charging"),
        ARMOR("armor"),
        JET_BOOTS("jet_boots", 5, new String[0]),
        NIGHT_VISION("night_vision"),
        SCUBA("scuba"),
        CREATIVE("creative"),
        AIR_CONDITIONING("air_conditioning", 1, "toughasnails"),
        INVENTORY("inventory"),
        JUMPING("jumping", 4, new String[0]),
        FLIPPERS("flippers"),
        STANDBY("standby"),
        MINIGUN("minigun"),
        RADIATION_SHIELDING("radiation_shielding", 1, "mekanism"),
        GILDED("gilded"),
        ENDER_VISOR("ender_visor"),
        STOMP("stomp"),
        ELYTRA("elytra"),
        CHUNKLOADER("chunkloader");

        private final String name;
        private final int maxTier;
        private final String[] depModIds;

        private BuiltinUpgrade(String name) {
            this(name, 1, new String[0]);
        }

        private BuiltinUpgrade(String name, int maxTier, String ... depModIds) {
            this.name = name;
            this.maxTier = maxTier;
            this.depModIds = depModIds;
        }

        public String getName() {
            return this.name;
        }

        public int getMaxTier() {
            return this.maxTier;
        }
    }
}

