/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.NotNull;

public final class CapabilityCache<T> {
    private LazyOptional<T> cachedCapability = LazyOptional.empty();
    private final NonNullConsumer<LazyOptional<T>> capabilityInvalidationListener = l -> {
        if (this.cachedCapability != l) {
            return;
        }
        this.cachedCapability = LazyOptional.empty();
    };

    @NotNull
    public LazyOptional<T> get() {
        return this.cachedCapability;
    }

    @NotNull
    public LazyOptional<T> set(LazyOptional<T> cap) {
        if (this.cachedCapability == cap) {
            return cap;
        }
        if (!cap.isPresent()) {
            this.cachedCapability = LazyOptional.empty();
            return this.cachedCapability;
        }
        this.cachedCapability = cap;
        cap.addListener(this.capabilityInvalidationListener);
        return this.cachedCapability;
    }

    public void clear() {
        this.cachedCapability = LazyOptional.empty();
    }
}

