/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.DisplayTableBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.TagWorkbenchMenu;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TagWorkbenchBlockEntity
extends DisplayTableBlockEntity
implements MenuProvider {
    public static final int PAPER_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    private final TagMatcherItemHandler inventory = new TagMatcherItemHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public int paperItemId;
    public int outputItemId;

    public TagWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.TAG_WORKBENCH.get()), pos, state);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.invCap;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (tag.startsWith("write:")) {
            String[] data = tag.substring(6).split(",");
            if (data.length == 0) {
                return;
            }
            ItemStack outputStack = ItemStack.f_41583_;
            if (!this.inventory.getStackInSlot(2).m_41619_()) {
                outputStack = this.inventory.getStackInSlot(2);
            } else if (!this.inventory.getStackInSlot(1).m_41619_()) {
                this.inventory.extractItem(1, 1, false);
                outputStack = new ItemStack((ItemLike)ModItems.TAG_FILTER.get());
            }
            if (!outputStack.m_41619_()) {
                Set<TagKey<Item>> tags = TagFilterItem.getConfiguredTagList(outputStack);
                for (String s : data) {
                    tags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(s)));
                }
                TagFilterItem.setConfiguredTagList(outputStack, tags);
                this.inventory.setStackInSlot(2, outputStack);
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
        this.displayedStack = this.inventory.getStackInSlot(0);
        this.paperItemId = Item.m_41393_((Item)this.inventory.getStackInSlot(1).m_41720_());
        this.outputItemId = Item.m_41393_((Item)this.inventory.getStackInSlot(2).m_41720_());
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.paperItemId = tag.m_128451_("PaperItemId");
        this.outputItemId = tag.m_128451_("OutputItemId");
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        tag.m_128405_("PaperItemId", this.paperItemId);
        tag.m_128405_("OutputItemId", this.outputItemId);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new TagWorkbenchMenu(windowId, inv, this.m_58899_());
    }

    private class TagMatcherItemHandler
    extends DisplayTableBlockEntity.DisplayItemHandler {
        TagMatcherItemHandler() {
            super(TagWorkbenchBlockEntity.this, 3);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return switch (slot) {
                case 0 -> true;
                case 1 -> {
                    if (stack.m_41720_() == Items.f_42516_ || stack.m_41720_() == ModItems.TAG_FILTER.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (stack.m_41720_() == ModItems.TAG_FILTER.get()) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalArgumentException("invalid slot " + slot);
            };
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 1) {
                TagWorkbenchBlockEntity.this.outputItemId = Item.m_41393_((Item)this.getStackInSlot(1).m_41720_());
            } else if (slot == 2) {
                TagWorkbenchBlockEntity.this.paperItemId = Item.m_41393_((Item)this.getStackInSlot(2).m_41720_());
            }
        }

        @Override
        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0, 2 -> 1;
                default -> 64;
            };
        }
    }
}

