/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.debug.DroneDebugger;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.LogisticsManager;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.inventory.ProgrammableControllerMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ProgrammableControllerBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IDroneBase,
ISideConfigurable,
MenuProvider {
    private static final int INVENTORY_SIZE = 1;
    private static final String FALLBACK_NAME = "[ProgController]";
    private static final UUID FALLBACK_UUID = UUID.nameUUIDFromBytes("[ProgController]".getBytes());
    private static final int MAX_ENERGY = 100000;
    public static final Set<ResourceLocation> BLACKLISTED_WIDGETS = ImmutableSet.of((Object)PneumaticRegistry.RL("computer_control"), (Object)PneumaticRegistry.RL("entity_attack"), (Object)PneumaticRegistry.RL("drone_condition_entity"), (Object)PneumaticRegistry.RL("standby"), (Object)PneumaticRegistry.RL("teleport"), (Object)PneumaticRegistry.RL("entity_export"), (Object[])new ResourceLocation[]{PneumaticRegistry.RL("entity_import")});
    private static final double SPEED_PER_UPGRADE = 0.05;
    private static final double BASE_SPEED = 0.15;
    private final ProgrammableItemStackHandler inventory = new ProgrammableItemStackHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    private final FluidTank tank = new FluidTank(16000);
    private final LazyOptional<IFluidHandler> tankCap = LazyOptional.of(() -> this.tank);
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final DroneItemHandler droneItemHandler = new DroneItemHandler(this, 1);
    private final ControllerNavigator controllerNavigator = new ControllerNavigator();
    private ProgrammableControllerEntity drone;
    private DroneAIManager aiManager;
    private DroneFakePlayer fakePlayer;
    private final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final int[] redstoneLevels = new int[6];
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private CompoundTag variablesNBT = null;
    @DescSynced
    private double targetX;
    @DescSynced
    private double targetY;
    @DescSynced
    private double targetZ;
    @DescSynced
    @LazySynced
    private double curX;
    @DescSynced
    @LazySynced
    private double curY;
    @DescSynced
    @LazySynced
    private double curZ;
    @DescSynced
    private int diggingX;
    @DescSynced
    private int diggingY;
    @DescSynced
    private int diggingZ;
    @DescSynced
    private int speedUpgrades;
    @DescSynced
    public boolean isIdle;
    @DescSynced
    public ItemStack heldItem = ItemStack.f_41583_;
    @GuiSynced
    public boolean shouldChargeHeldItem;
    @DescSynced
    public String label = "";
    @DescSynced
    public String ownerNameClient = "";
    @GuiSynced
    private boolean chunkloadSelf = false;
    @GuiSynced
    private boolean chunkloadWorkingChunk = false;
    @GuiSynced
    private boolean chunkloadWorkingChunk3x3 = false;
    private ChunkPos prevChunkPos = null;
    private final Set<ChunkPos> loadedChunks = new HashSet<ChunkPos>();
    private UUID ownerID;
    private Component ownerName;
    private boolean shouldUpdateNeighbours;
    private LogisticsManager logisticsManager;
    private final DroneDebugger debugger = new DroneDebugger(this);
    @DescSynced
    private int activeWidgetIndex;

    public ProgrammableControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PROGRAMMABLE_CONTROLLER.get(), pos, state, PressureTier.TIER_TWO, 10000, 4);
        MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent(this));
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("droneInv", new ItemStack((ItemLike)ModItems.DRONE.get()), (Capability<IItemHandler>)ForgeCapabilities.ITEM_HANDLER, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.droneItemHandler), SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("programmableInv", new ItemStack((ItemLike)ModItems.NETWORK_API.get()), (Capability<IItemHandler>)ForgeCapabilities.ITEM_HANDLER, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.inventory), SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.setNullFaceHandler("droneInv");
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().f_46443_ && event.getWorld() == this.m_58904_() && event.getSemiblock() instanceof AbstractLogisticsFrameEntity) {
            this.logisticsManager = null;
        }
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        double speed = 0.15 + (double)this.speedUpgrades * 0.05;
        if (PneumaticCraftUtils.distBetweenSq(this.curX, this.curY, this.curZ, this.targetX, this.targetY, this.targetZ) > speed / 2.0) {
            Vec3 vec = new Vec3(this.targetX - this.curX, this.targetY - this.curY, this.targetZ - this.curZ).m_82541_().m_82490_(speed);
            this.curX += vec.f_82479_;
            this.curY += vec.f_82480_;
            this.curZ += vec.f_82481_;
        } else {
            this.curX = this.targetX;
            this.curY = this.targetY;
            this.curZ = this.targetZ;
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if ((this.drone == null || !this.drone.m_6084_()) && this.nonNullLevel().m_46749_(new BlockPos(this.curX, this.curY, this.curZ))) {
            this.drone = (ProgrammableControllerEntity)((EntityType)ModEntityTypes.PROGRAMMABLE_CONTROLLER.get()).m_20615_(this.nonNullLevel());
            if (this.drone != null) {
                this.drone.setController(this);
                this.drone.m_6034_(this.curX, this.curY, this.curZ);
                ClientUtils.spawnEntityClientside((Entity)this.drone);
            }
        } else if (this.drone != null) {
            this.drone.m_6034_(this.curX, this.curY, this.curZ);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.shouldUpdateNeighbours) {
            this.updateNeighbours();
            this.shouldUpdateNeighbours = false;
        }
        DroneFakePlayer fp = this.getFakePlayer();
        for (int i = 0; i < 4; ++i) {
            fp.f_8941_.m_7712_();
        }
        fp.m_6034_(this.curX, this.curY, this.curZ);
        ChunkPos newChunkPos = new ChunkPos((int)this.curX >> 4, (int)this.curZ >> 4);
        if (this.prevChunkPos == null || !this.prevChunkPos.equals((Object)newChunkPos)) {
            this.handleDynamicChunkloading(newChunkPos);
        }
        this.prevChunkPos = newChunkPos;
        fp.m_8119_();
        ItemStack itemStack = this.heldItem = (Boolean)ConfigHelper.common().drones.dronesRenderHeldItem.get() != false ? fp.m_21205_() : ItemStack.f_41583_;
        if (this.getPressure() >= this.getMinWorkingPressure()) {
            if (!this.isIdle) {
                this.addAir(-10);
                if (this.chunkloadWorkingChunk3x3) {
                    this.addAir(-30);
                } else if (this.chunkloadWorkingChunk) {
                    this.addAir(-10);
                }
            }
            if (this.chunkloadSelf) {
                this.addAir(-10);
            }
            DroneAIManager prevActive = this.getActiveAIManager();
            this.aiManager.onUpdateTasks();
            if (this.getActiveAIManager() != prevActive) {
                this.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(new PacketSyncDroneEntityProgWidgets(this), p));
            }
            this.maybeChargeHeldItem();
        }
        if (this.nonNullLevel().m_46467_() % 20L == 0L) {
            this.debugger.updateDebuggingPlayers();
        }
    }

    private void handleDynamicChunkloading(ChunkPos newPos) {
        for (int cx = newPos.f_45578_ - 1; cx <= newPos.f_45578_ + 1; ++cx) {
            for (int cz = newPos.f_45579_ - 1; cz <= newPos.f_45579_ + 1; ++cz) {
                ChunkPos cp = new ChunkPos(cx, cz);
                if (!this.shouldLoadChunk(cp)) continue;
                this.loadedChunks.add(cp);
            }
        }
        Iterator<ChunkPos> iter = this.loadedChunks.iterator();
        while (iter.hasNext()) {
            ChunkPos cp = iter.next();
            boolean load = this.shouldLoadChunk(cp);
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.nonNullLevel()), (String)"pneumaticcraft", (BlockPos)this.f_58858_, (int)cp.f_45578_, (int)cp.f_45579_, (boolean)load, (boolean)false);
            if (load) continue;
            iter.remove();
        }
    }

    private boolean shouldLoadChunk(ChunkPos cp) {
        int cx = (int)this.curX >> 4;
        int cz = (int)this.curZ >> 4;
        return this.chunkloadSelf && cp.f_45578_ == this.f_58858_.m_123341_() >> 4 && cp.f_45579_ == this.f_58858_.m_123343_() >> 4 || this.chunkloadWorkingChunk && !this.isIdle && cp.f_45578_ == cx && cp.f_45579_ == cz || this.chunkloadWorkingChunk3x3 && !this.isIdle && cp.f_45578_ >= cx - 1 && cp.f_45578_ <= cx + 1 && cp.f_45579_ >= cz - 1 && cp.f_45579_ <= cz + 1;
    }

    private void maybeChargeHeldItem() {
        if (!this.shouldChargeHeldItem) {
            return;
        }
        ItemStack held = this.droneItemHandler.getStackInSlot(0);
        if (this.energy.getEnergyStored() > 100) {
            held.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
                if (handler.getMaxEnergyStored() - handler.getEnergyStored() > 250) {
                    handler.receiveEnergy(this.energy.extractEnergy(250, false), false);
                }
            });
        }
        held.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
            if (this.getPressure() > handler.getPressure() && handler.getPressure() < handler.maxPressure()) {
                int maxAir = (int)(handler.maxPressure() * (float)handler.getVolume());
                int toAdd = Math.min(250, maxAir - handler.getAir());
                handler.addAir(toAdd);
                this.airHandler.addAir(-toAdd);
            }
        });
    }

    @Override
    public void onVariableChanged(String varname, boolean isCoordinate) {
        this.m_6596_();
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ instanceof ServerLevel) {
            this.loadedChunks.forEach(cp -> ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"pneumaticcraft", (BlockPos)this.f_58858_, (int)cp.f_45578_, (int)cp.f_45579_, (boolean)false, (boolean)false));
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.itemHandlerSideConfigurator.invalidateCaps();
    }

    @Override
    public UUID getOwnerUUID() {
        if (this.ownerID == null) {
            this.ownerID = UUID.randomUUID();
            this.ownerName = Component.m_237113_((String)"[Programmable Controller]");
            Log.warning(String.format("Programmable controller with owner '%s' has no UUID! Substituting a random UUID (%s).", this.ownerName, this.ownerID), new Object[0]);
        }
        return this.ownerID;
    }

    @Override
    public BlockPos getDeployPos() {
        return this.m_58899_();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (tag.equals("charging")) {
            this.shouldChargeHeldItem = !this.shouldChargeHeldItem;
        } else if (tag.equals("chunkload_self")) {
            this.chunkloadSelf = !this.chunkloadSelf;
        } else if (tag.equals("chunkload_work")) {
            this.chunkloadWorkingChunk = !this.chunkloadWorkingChunk;
        } else if (tag.equals("chunkload_work_3x3")) {
            this.chunkloadWorkingChunk3x3 = !this.chunkloadWorkingChunk3x3;
        } else if (this.itemHandlerSideConfigurator.handleButtonPress(tag, shiftHeld)) {
            this.shouldUpdateNeighbours = true;
        }
        this.m_6596_();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    public void setOwner(Player ownerID) {
        this.ownerID = ownerID.m_20148_();
        this.ownerName = ownerID.m_7755_();
        this.ownerNameClient = this.ownerName.getString();
    }

    @Override
    public List<SideConfigurator<?>> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ProgrammableControllerMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            this.calculateUpgrades();
        }
    }

    private void calculateUpgrades() {
        int newInvUpgrades;
        int oldInvUpgrades = this.droneItemHandler.getSlots() - 1;
        if (oldInvUpgrades != (newInvUpgrades = Math.min(35, this.getUpgrades((PNCUpgrade)ModUpgrades.INVENTORY.get())))) {
            this.resizeDroneInventory(oldInvUpgrades + 1, newInvUpgrades + 1);
            this.tank.setCapacity((newInvUpgrades + 1) * 16000);
            if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
                this.tank.getFluid().setAmount(this.tank.getCapacity());
            }
        }
        this.speedUpgrades = this.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get());
    }

    private void resizeDroneInventory(int oldSize, int newSize) {
        for (int i = newSize; i < oldSize; ++i) {
            ItemStack stack = this.droneItemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            this.droneItemHandler.setStackInSlot(i, ItemStack.f_41583_);
            PneumaticCraftUtils.dropItemOnGround(stack, this.m_58904_(), this.m_58899_().m_7494_());
        }
        this.droneItemHandler.setUseableSlots(newSize);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
        this.tank.setCapacity((this.getUpgrades((PNCUpgrade)ModUpgrades.INVENTORY.get()) + 1) * 16000);
        this.tank.readFromNBT(tag.m_128469_("tank"));
        this.ownerID = tag.m_128441_("ownerID") ? UUID.fromString(tag.m_128461_("ownerID")) : FALLBACK_UUID;
        this.ownerName = Component.m_237113_((String)(tag.m_128441_("ownerName") ? tag.m_128461_("ownerName") : FALLBACK_NAME));
        this.ownerNameClient = this.ownerName.getString();
        this.droneItemHandler.setUseableSlots(this.getUpgrades((PNCUpgrade)ModUpgrades.INVENTORY.get()) + 1);
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT(tag.m_128469_("droneItems"));
        for (int i = 0; i < Math.min(tmpInv.getSlots(), this.droneItemHandler.getSlots()); ++i) {
            this.droneItemHandler.setStackInSlot(i, tmpInv.getStackInSlot(i).m_41777_());
        }
        this.energy.readFromNBT(tag);
        this.itemHandlerSideConfigurator.updateHandler("droneInv", (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.droneItemHandler));
        this.shouldChargeHeldItem = tag.m_128471_("chargeHeld");
        this.variablesNBT = tag.m_128469_("variables");
        this.chunkloadSelf = tag.m_128471_("chunkload_self");
        this.chunkloadWorkingChunk = tag.m_128471_("chunkload_work");
        this.chunkloadWorkingChunk3x3 = tag.m_128471_("chunkload_work_3x3");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
        CompoundTag tankTag = new CompoundTag();
        this.tank.writeToNBT(tankTag);
        tag.m_128365_("tank", (Tag)tankTag);
        ItemStackHandler handler = new ItemStackHandler(this.droneItemHandler.getSlots());
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            handler.setStackInSlot(i, this.droneItemHandler.getStackInSlot(i));
        }
        tag.m_128365_("droneItems", (Tag)handler.serializeNBT());
        if (this.ownerID != null) {
            tag.m_128359_("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            tag.m_128359_("ownerName", this.ownerName.getString());
        }
        this.energy.writeToNBT(tag);
        tag.m_128379_("chargeHeld", this.shouldChargeHeldItem);
        if (this.aiManager != null) {
            tag.m_128365_("variables", (Tag)this.aiManager.writeToNBT(new CompoundTag()));
        }
        tag.m_128379_("chunkload_self", this.chunkloadSelf);
        tag.m_128379_("chunkload_work", this.chunkloadWorkingChunk);
        tag.m_128379_("chunkload_work_3x3", this.chunkloadWorkingChunk3x3);
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.itemHandlerSideConfigurator.getHandler(side);
    }

    @Override
    @NotNull
    public LazyOptional<IFluidHandler> getFluidCap(Direction side) {
        return this.tankCap;
    }

    @Override
    @NotNull
    protected LazyOptional<IEnergyStorage> getEnergyCap(Direction side) {
        return this.energyCap;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.droneItemHandler.setFakePlayerReady();
        this.calculateUpgrades();
        this.inventory.onContentsChanged(0);
        this.curX = this.targetX = (double)this.m_58899_().m_123341_() + 0.5;
        this.curY = this.targetY = (double)this.m_58899_().m_123342_() + 1.0;
        this.curZ = this.targetZ = (double)this.m_58899_().m_123343_() + 0.5;
        if (this.chunkloadSelf) {
            ChunkPos cp = new ChunkPos(this.f_58858_);
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.nonNullLevel()), (String)"pneumaticcraft", (BlockPos)this.f_58858_, (int)cp.f_45578_, (int)cp.f_45579_, (boolean)true, (boolean)false);
            this.loadedChunks.add(cp);
        }
    }

    private static boolean isProgrammableAndValidForDrone(IDroneBase drone, ItemStack programmable) {
        IProgrammable p;
        Item item = programmable.m_41720_();
        if (item instanceof IProgrammable && (p = (IProgrammable)item).canProgram(programmable) && p.usesPieces(programmable)) {
            List<IProgWidget> widgets = ProgrammerBlockEntity.getProgWidgets(programmable);
            return widgets.stream().allMatch(widget -> drone.isProgramApplicable(widget.getType()));
        }
        return false;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public Level world() {
        return this.m_58904_();
    }

    @Override
    public IFluidTank getFluidTank() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.droneItemHandler;
    }

    @Override
    public Vec3 getDronePos() {
        if (this.curX == 0.0 && this.curY == 0.0 && this.curZ == 0.0) {
            this.curX = (double)this.m_58899_().m_123341_() + 0.5;
            this.curY = (double)this.m_58899_().m_123342_() + 1.0;
            this.curZ = (double)this.m_58899_().m_123343_() + 0.5;
            this.targetX = this.curX;
            this.targetY = this.curY;
            this.targetZ = this.curZ;
        }
        return new Vec3(this.curX, this.curY, this.curZ);
    }

    public BlockPos getTargetPos() {
        return new BlockPos(this.targetX, this.targetY, this.targetZ);
    }

    @Override
    public BlockPos getControllerPos() {
        return this.f_58858_;
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return this.controllerNavigator;
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
    }

    @Override
    public DroneFakePlayer getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = new DroneFakePlayer((ServerLevel)this.nonNullLevel(), new GameProfile(this.getOwnerUUID(), this.ownerName.getString()), this);
        }
        return this.fakePlayer;
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        return !this.nonNullLevel().m_8055_(pos).m_60742_((BlockGetter)this.nonNullLevel(), pos, CollisionContext.m_82749_()).equals(Shapes.m_83144_());
    }

    @Override
    public void dropItem(ItemStack stack) {
        Vec3 pos = this.getDronePos();
        this.nonNullLevel().m_7967_((Entity)new ItemEntity(this.nonNullLevel(), pos.f_82479_, pos.f_82480_, pos.f_82481_, stack));
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        super.getContentsToDrop(drops);
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            if (this.fakePlayer.m_150109_().m_8020_(i).m_41619_()) continue;
            drops.add((Object)this.fakePlayer.m_150109_().m_8020_(i).m_41777_());
        }
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        if (pos != null) {
            this.diggingX = pos.m_123341_();
            this.diggingY = pos.m_123342_();
            this.diggingZ = pos.m_123343_();
        } else {
            this.diggingZ = 0;
            this.diggingY = 0;
            this.diggingX = 0;
        }
    }

    public BlockPos getDugPosition() {
        return this.diggingX != 0 || this.diggingY != 0 || this.diggingZ != 0 ? new BlockPos(this.diggingX, this.diggingY, this.diggingZ) : null;
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.activeWidgetIndex = this.progWidgets.indexOf(widget);
    }

    @Override
    public boolean isProgramApplicable(ProgWidgetType<?> widgetType) {
        return PneumaticCraftUtils.getRegistryName(ModProgWidgets.PROG_WIDGETS.get(), widgetType).map(regName -> !BLACKLISTED_WIDGETS.contains(regName)).orElseThrow();
    }

    @Override
    public GoalSelector getTargetAI() {
        return null;
    }

    @Override
    public void setEmittingRedstone(Direction orientation, int emittingRedstone) {
        this.redstoneLevels[orientation.m_122411_()] = emittingRedstone;
        this.updateNeighbours();
    }

    @Override
    public int getEmittingRedstone(Direction direction) {
        return this.redstoneLevels[direction.m_122411_()];
    }

    @Override
    public void setName(Component name) {
        ItemStack stack;
        if (this.drone != null) {
            this.drone.m_6593_(name);
        }
        if (!(stack = this.inventory.getStackInSlot(0).m_41777_()).m_41619_()) {
            stack.m_41714_(name);
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        Log.warning("Drone AI setting carrying entity. However a Programmable Controller can't carry entities!", new Object[0]);
        new Throwable().printStackTrace();
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAIOverridden() {
        return false;
    }

    @Override
    public void onItemPickupEvent(ItemEntity curPickingUpEntity, int stackSize) {
    }

    @Override
    public Player getOwner() {
        if (this.ownerID == null) {
            return null;
        }
        if (this.nonNullLevel().f_46443_) {
            return ClientUtils.getClientPlayer();
        }
        return PneumaticCraftUtils.getPlayerFromId(this.ownerID);
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        ItemStack stack = this.inventory.extractItem(0, 1, false);
        if (stack.m_41613_() == 1) {
            boolean inserted = this.findEjectionDest().map(h -> ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false).m_41619_()).orElse(false);
            if (!inserted) {
                PneumaticCraftUtils.dropItemOnGround(stack, this.f_58857_, this.f_58858_.m_7494_());
            }
            this.nonNullLevel().m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.DRONE_DEATH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123762_, (double)this.m_58899_().m_123341_() - 0.5, this.m_58899_().m_123342_() + 1, (double)this.m_58899_().m_123343_() - 0.5, 0.0, 0.0, 0.0, 10, 1.0, 1.0, 1.0), this);
    }

    @Override
    public DroneAIManager getAIManager() {
        if (!this.nonNullLevel().f_46443_ && this.aiManager == null) {
            this.aiManager = new DroneAIManager(this, new ArrayList<IProgWidget>());
            this.aiManager.dontStopWhenEndReached();
            if (this.variablesNBT != null) {
                this.aiManager.readFromNBT(this.variablesNBT);
                this.variablesNBT = null;
            }
        }
        return this.aiManager;
    }

    @Override
    public void updateLabel() {
        this.label = this.aiManager != null ? this.getAIManager().getLabel() : "Main";
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    @Override
    public void playSound(SoundEvent soundEvent, SoundSource category, float volume, float pitch) {
    }

    @Override
    public void addAirToDrone(int air) {
        this.airHandler.addAir(air);
    }

    @Override
    public boolean canMoveIntoFluid(Fluid fluid) {
        return true;
    }

    @Override
    public DroneItemHandler getDroneItemHandler() {
        return this.droneItemHandler;
    }

    @Override
    public float getDronePressure() {
        return this.getPressure();
    }

    @Override
    public int getActiveWidgetIndex() {
        return this.activeWidgetIndex;
    }

    @Override
    public DroneDebugger getDebugger() {
        return this.debugger;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Component getDroneName() {
        return this.m_5446_();
    }

    @Override
    public void storeTrackerData(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("debuggingPC", (Tag)NbtUtils.m_129224_((BlockPos)this.m_58899_()));
        tag.m_128473_("debuggingDrone");
    }

    @Override
    public boolean isDroneStillValid() {
        return !this.f_58859_;
    }

    public boolean chunkloadSelf() {
        return this.chunkloadSelf;
    }

    public boolean chunkloadWorkingChunk() {
        return this.chunkloadWorkingChunk;
    }

    public boolean chunkloadWorkingChunk3x3() {
        return this.chunkloadWorkingChunk3x3;
    }

    private LazyOptional<IItemHandler> findEjectionDest() {
        Direction dir = null;
        for (Direction d : DirectionUtil.VALUES) {
            if (!this.getCapability(ForgeCapabilities.ITEM_HANDLER, d).map(h -> h == this.inventory).orElse(false).booleanValue()) continue;
            dir = d;
            break;
        }
        if (dir != null) {
            BlockEntity te = this.nonNullLevel().m_7702_(this.f_58858_.m_121945_(dir));
            return IOHelper.getInventoryForTE(te, dir.m_122424_());
        }
        return LazyOptional.empty();
    }

    private class ProgrammableItemStackHandler
    extends BaseItemStackHandler {
        ProgrammableItemStackHandler(BlockEntity te) {
            super(te, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemStack stack = this.getStackInSlot(slot);
            ProgrammableControllerBlockEntity.this.progWidgets.clear();
            if (!stack.m_41619_() && ProgrammableControllerBlockEntity.isProgrammableAndValidForDrone(ProgrammableControllerBlockEntity.this, stack)) {
                ProgrammableControllerBlockEntity.this.progWidgets.addAll(ProgrammerBlockEntity.getProgWidgets(stack));
                ProgrammerBlockEntity.updatePuzzleConnections(ProgrammableControllerBlockEntity.this.progWidgets);
                ProgrammableControllerBlockEntity.this.isIdle = false;
            } else {
                ProgrammableControllerBlockEntity.this.setDugBlock(null);
                ProgrammableControllerBlockEntity.this.targetX = (double)ProgrammableControllerBlockEntity.this.m_58899_().m_123341_() + 0.5;
                ProgrammableControllerBlockEntity.this.targetY = (double)ProgrammableControllerBlockEntity.this.m_58899_().m_123342_() + 1.0;
                ProgrammableControllerBlockEntity.this.targetZ = (double)ProgrammableControllerBlockEntity.this.m_58899_().m_123343_() + 0.5;
                boolean updateNeighbours = false;
                for (int i = 0; i < ProgrammableControllerBlockEntity.this.redstoneLevels.length; ++i) {
                    if (ProgrammableControllerBlockEntity.this.redstoneLevels[i] <= 0) continue;
                    ProgrammableControllerBlockEntity.this.redstoneLevels[i] = 0;
                    updateNeighbours = true;
                }
                if (updateNeighbours) {
                    ProgrammableControllerBlockEntity.this.updateNeighbours();
                }
                ProgrammableControllerBlockEntity.this.isIdle = true;
            }
            if (ProgrammableControllerBlockEntity.this.m_58904_() != null && !ProgrammableControllerBlockEntity.this.m_58904_().f_46443_) {
                ProgrammableControllerBlockEntity.this.aiManager = null;
                ProgrammableControllerBlockEntity.this.aiManager = ProgrammableControllerBlockEntity.this.getAIManager();
                ProgrammableControllerBlockEntity.this.aiManager.setWidgets(ProgrammableControllerBlockEntity.this.progWidgets);
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || ProgrammableControllerBlockEntity.isProgrammableAndValidForDrone(ProgrammableControllerBlockEntity.this, itemStack);
        }
    }

    private class ControllerNavigator
    implements IPathNavigator {
        private ControllerNavigator() {
        }

        @Override
        public boolean moveToXYZ(double x, double y, double z) {
            if (ProgrammableControllerBlockEntity.this.isBlockValidPathfindBlock(new BlockPos(x, y, z))) {
                ProgrammableControllerBlockEntity.this.targetX = x + 0.5;
                ProgrammableControllerBlockEntity.this.targetY = y + 0.5;
                ProgrammableControllerBlockEntity.this.targetZ = z + 0.5;
                return true;
            }
            return false;
        }

        @Override
        public boolean moveToEntity(Entity entity) {
            return this.moveToXYZ(entity.m_20185_(), entity.m_20186_() + 0.3, entity.m_20189_());
        }

        @Override
        public boolean hasNoPath() {
            return PneumaticCraftUtils.distBetweenSq(ProgrammableControllerBlockEntity.this.curX, ProgrammableControllerBlockEntity.this.curY, ProgrammableControllerBlockEntity.this.curZ, ProgrammableControllerBlockEntity.this.targetX, ProgrammableControllerBlockEntity.this.targetY, ProgrammableControllerBlockEntity.this.targetZ) < 0.5;
        }

        @Override
        public boolean isGoingToTeleport() {
            return false;
        }
    }
}

