/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.StringUtils;

public class GuiUtils {
    private static final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    public static final String TRANSLATION_LINE_BREAK = "${br}";

    public static void renderBlockInGui(PoseStack matrixStack, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.m_91087_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, (double)z);
        matrixStack.m_85841_(scale, -scale, scale);
        matrixStack.m_85837_(-0.5, -1.0, 0.0);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
        matrixStack.m_85837_(0.5, 0.0, -0.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotate));
        matrixStack.m_85837_(-0.5, 0.0, 0.5);
        matrixStack.m_85837_(0.0, 0.0, -1.0);
        GuiUtils.bindTexture(InventoryMenu.f_39692_);
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        mc.m_91289_().renderSingleBlock(block, matrixStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        buffers.m_109911_();
        matrixStack.m_85849_();
    }

    public static void drawFluid(PoseStack poseStack, Rect2i bounds, @Nullable FluidStack fluidStack, @Nullable IFluidTank tank) {
        int scaledAmount;
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProps.getStillTexture(fluidStack);
        if (fluidStill == null) {
            fluidStill = MissingTextureAtlasSprite.m_118071_();
        }
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidStill);
        int n = scaledAmount = tank == null ? bounds.m_110091_() : fluidStack.getAmount() * bounds.m_110091_() / tank.getCapacity();
        if (fluidStack.getAmount() > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        scaledAmount = Math.min(scaledAmount, bounds.m_110091_());
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        int xTileCount = bounds.m_110090_() / 16;
        int xRemainder = bounds.m_110090_() - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = bounds.m_110086_() + bounds.m_110091_();
        if (fluid.getFluidType().getDensity() < 0) {
            yStart -= bounds.m_110091_() - scaledAmount;
        }
        int[] cols = RenderUtils.decomposeColor(renderProps.getTintColor(fluidStack));
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = bounds.m_110085_() + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (bounds.m_110090_() <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                GuiUtils.drawFluidTexture(poseStack, x, y, fluidStillSprite, maskTop, maskRight, 100.0f, cols);
            }
        }
        RenderSystem.m_69461_();
    }

    private static void drawFluidTexture(PoseStack matrixStack, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel, int[] cols) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder worldrenderer = tessellator.m_85915_();
        worldrenderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        worldrenderer.m_85982_(posMat, xCoord, yCoord + 16.0f, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMin, vMax).m_5752_();
        worldrenderer.m_85982_(posMat, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMax, vMax).m_5752_();
        worldrenderer.m_85982_(posMat, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMax, vMin).m_5752_();
        worldrenderer.m_85982_(posMat, xCoord, yCoord + (float)maskTop, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public static Rect2i showPopupHelpScreen(PoseStack matrixStack, Screen screen, Font fontRenderer, List<Component> helpText) {
        int y;
        int x;
        List<FormattedCharSequence> l = GuiUtils.wrapTextComponentList(helpText, screen.f_96543_ / 2, fontRenderer);
        Objects.requireNonNull(fontRenderer);
        int lineSpacing = 9 + 1;
        int boxHeight = l.size() * lineSpacing;
        int maxLines = boxHeight / lineSpacing;
        int boxWidth = l.stream().max(Comparator.comparingInt(arg_0 -> ((Font)fontRenderer).m_92724_(arg_0))).map(arg_0 -> ((Font)fontRenderer).m_92724_(arg_0)).orElse(0);
        float fontScale = 1.0f;
        while (boxHeight > screen.f_96544_ - 5) {
            boxHeight /= 2;
            boxWidth /= 2;
            fontScale /= 2.0f;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen a = (AbstractContainerScreen)screen;
            x = (a.getXSize() - boxWidth) / 2;
            y = (a.getYSize() - boxHeight) / 2;
        } else {
            x = (screen.f_96543_ - boxWidth) / 2;
            y = (screen.f_96544_ - boxHeight) / 2;
        }
        Rect2i bounds = new Rect2i(x, y, boxWidth, boxHeight);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 400.0);
        GuiUtils.drawPanel(matrixStack, 0, 0, boxHeight, boxWidth);
        int dy = 0;
        matrixStack.m_85841_(fontScale, fontScale, fontScale);
        for (FormattedCharSequence line : l) {
            fontRenderer.m_92877_(matrixStack, line, 0.0f, (float)dy, -2039584);
            dy += lineSpacing;
            if (maxLines-- != 0) continue;
            break;
        }
        matrixStack.m_85849_();
        return bounds;
    }

    public static void drawPanel(PoseStack matrixStack, int x, int y, int panelHeight, int panelWidth) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x - 4), (int)(y - 4), (int)(x + panelWidth + 8), (int)(y + panelHeight + 8), (int)-1073741824);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x - 4), (int)(y - 4), (int)(x + panelWidth + 8), (int)(y - 3), (int)-8355712);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x - 4), (int)(y + panelHeight + 8), (int)(x + panelWidth + 8), (int)(y + panelHeight + 9), (int)-8355712);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x - 4), (int)(y - 4), (int)(x - 3), (int)(y + panelHeight + 8), (int)-8355712);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x + panelWidth + 8), (int)(y - 4), (int)(x + panelWidth + 9), (int)(y + panelHeight + 8), (int)-8355712);
    }

    public static void drawTexture(PoseStack matrixStack, ResourceLocation texture, int x, int y) {
        GuiUtils.bindTexture(texture);
        RenderSystem.m_69493_();
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_85982_(posMat, (float)x, (float)(y + 16), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, (float)(x + 16), (float)(y + 16), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, (float)(x + 16), (float)y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_85982_(posMat, (float)x, (float)y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void drawUntexturedQuad(PoseStack matrixStack, BufferBuilder renderer, float x, float y, float z, float width, float height, int red, int green, int blue, int alpha) {
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_85982_(posMat, x, y, z).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(posMat, x, y + height, z).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(posMat, x + width, y + height, z).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(posMat, x + width, y, z).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void drawOutline(PoseStack matrixStack, BufferBuilder renderer, float x, float y, float z, float width, float height, int red, int green, int blue, int alpha) {
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        renderer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        renderer.m_85982_(posMat, x, y, z).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(posMat, x, y + height, z).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(posMat, x + width, y + height, z).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(posMat, x + width, y, z).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(posMat, x, y, z).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void drawScaledText(PoseStack matrixStack, Font fr, String text, int x, int y, int color, float scale) {
        if (scale != 1.0f) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x, (double)y, 0.0);
            matrixStack.m_85841_(scale, scale, scale);
            fr.m_92883_(matrixStack, text, 0.0f, 0.0f, color);
            matrixStack.m_85849_();
        } else {
            fr.m_92883_(matrixStack, text, (float)x, (float)y, color);
        }
    }

    public static List<FormattedCharSequence> wrapTextComponentList(List<Component> text, int maxWidth, Font font) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Component line : text) {
            builder.addAll((Iterable)ComponentRenderUtils.m_94005_((FormattedText)line, (int)maxWidth, (Font)font));
        }
        return builder.build();
    }

    public static List<Component> xlateAndSplit(String key, Object ... params) {
        return Arrays.stream(StringUtils.splitByWholeSeparator((String)I18n.m_118938_((String)key, (Object[])params), (String)TRANSLATION_LINE_BREAK)).map(Component::m_237113_).collect(Collectors.toList());
    }

    public static void bindTexture(ResourceLocation texture, float r, float g, float b, float a) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void bindTexture(ResourceLocation texture) {
        GuiUtils.bindTexture(texture, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderProgressingLine2d(PoseStack matrixStack, ProgressingLine line, int color, float lineWidth) {
        int[] cols = RenderUtils.decomposeColor(color);
        float progress = line.getProgress();
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69832_((float)lineWidth);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        wr.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        wr.m_85982_(posMat, line.startX, line.startY, line.startZ).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        wr.m_85982_(posMat, Mth.m_14179_((float)progress, (float)line.startX, (float)line.endX), Mth.m_14179_((float)progress, (float)line.startY, (float)line.endY), Mth.m_14179_((float)progress, (float)line.startZ, (float)line.endZ)).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

