/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class WidgetList<T>
extends AbstractWidget
implements ITooltipProvider {
    @Nonnull
    private final Consumer<WidgetList<T>> pressable;
    private final List<T> items = new ArrayList<T>();
    private int selected = -1;
    private long lastClick = 0L;
    private boolean doubleClicked;
    private int fgColor = 0x404040;
    private int selectedFg = 0xFFFFFF;
    private int selectedBg = 0;
    private boolean inverseSelected = true;
    private ToolTipType toolTipType = ToolTipType.AUTO;

    public WidgetList(int xIn, int yIn, int width, int height) {
        this(xIn, yIn, width, height, c -> {});
    }

    public WidgetList(int xIn, int yIn, int width, int height, @Nonnull Consumer<WidgetList<T>> pressable) {
        super(xIn, yIn, width, height, (Component)Component.m_237119_());
        this.pressable = pressable;
    }

    public WidgetList<T> setColor(int color) {
        this.fgColor = color;
        return this;
    }

    public WidgetList<T> setToolTipType(ToolTipType toolTipType) {
        this.toolTipType = toolTipType;
        return this;
    }

    public WidgetList<T> setSelectedColors(int selectedFg, int selectedBg) {
        this.selectedFg = selectedFg;
        this.selectedBg = selectedBg;
        return this;
    }

    public WidgetList<T> inverseSelected(boolean inverse) {
        this.inverseSelected = inverse;
        return this;
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            this.drawList(matrixStack);
        }
    }

    public boolean isDoubleClicked() {
        return this.doubleClicked;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public void unselectAll() {
        this.selected = -1;
    }

    public List<T> getLines() {
        return ImmutableList.copyOf(this.items);
    }

    public T getSelectedLine() {
        return this.selected >= 0 && this.selected < this.items.size() ? (T)this.items.get(this.selected) : null;
    }

    public boolean contains(T s) {
        return this.items.contains(s);
    }

    public void add(T s) {
        this.items.add(s);
    }

    public void removeSelected() {
        if (this.selected >= 0 && this.selected < this.items.size()) {
            this.items.remove(this.selected);
            this.updateSelection();
        }
    }

    public void clear() {
        this.items.clear();
        this.setSelected(-1);
    }

    private void updateSelection() {
        if (this.items.isEmpty()) {
            this.selected = -1;
        } else if (this.selected >= this.items.size()) {
            this.selected = this.items.size() - 1;
        }
    }

    public int size() {
        return this.items.size();
    }

    private void drawList(PoseStack matrixStack) {
        Minecraft mc = Minecraft.m_91087_();
        int scale = (Integer)mc.f_91066_.m_231928_().m_231551_();
        Objects.requireNonNull(mc.f_91062_);
        int lineHeight = 9;
        int lines = this.f_93619_ / lineHeight;
        matrixStack.m_85836_();
        WidgetList.m_239260_((int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_));
        if (this.inverseSelected && this.selected >= 0) {
            RenderSystem.m_69472_();
            WidgetList.m_93172_((PoseStack)matrixStack, (int)this.f_93620_, (int)(this.f_93621_ + lineHeight * this.selected), (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + lineHeight * (this.selected + 1)), (int)(0xFF000000 | this.selectedBg));
            RenderSystem.m_69493_();
        }
        matrixStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        matrixStack.m_85841_(0.75f, 1.0f, 1.0f);
        for (int i = 0; i < this.items.size() && i < lines; ++i) {
            mc.f_91062_.m_92883_(matrixStack, this.items.get(i).toString(), 0.0f, (float)(i * lineHeight), i == this.selected ? this.selectedFg : this.fgColor);
        }
        WidgetList.m_240060_();
        matrixStack.m_85849_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.f_93623_) {
            long now = System.currentTimeMillis();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int h = 9;
            int newSel = Mth.m_14045_((int)((int)(mouseY - (double)this.f_93621_) / h), (int)0, (int)(this.items.size() - 1));
            this.doubleClicked = now - this.lastClick < 250L && newSel == this.selected;
            this.setSelected(newSel);
            this.lastClick = now;
            this.pressable.accept(this);
        }
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shift) {
        if (this.toolTipType == ToolTipType.NONE) {
            return;
        }
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int h = 9;
        int idx = Math.max(0, (int)(mouseY - (double)this.f_93621_) / h);
        if (idx >= 0 && idx < this.items.size()) {
            String s = this.items.get(idx).toString();
            if (this.toolTipType == ToolTipType.ALWAYS || Minecraft.m_91087_().f_91062_.m_92895_(s) * 3 / 4 > this.f_93618_) {
                curTip.add((Component)Component.m_237113_((String)s));
            }
        }
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static enum ToolTipType {
        NONE,
        AUTO,
        ALWAYS;

    }
}

