/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.ThermopneumaticProcessingPlantBlockEntity;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ThermopneumaticProcessingPlantMenu;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ThermopneumaticProcessingPlantScreen
extends AbstractPneumaticCraftContainerScreen<ThermopneumaticProcessingPlantMenu, ThermopneumaticProcessingPlantBlockEntity> {
    private WidgetTemperature tempWidget;
    private WidgetButtonExtended dumpButton;
    private int nExposedFaces;

    public ThermopneumaticProcessingPlantScreen(ThermopneumaticProcessingPlantMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97727_ = 212;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_THERMOPNEUMATIC_PROCESSING_PLANT;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new WidgetTank(this.f_97735_ + 13, this.f_97736_ + 19, ((ThermopneumaticProcessingPlantBlockEntity)this.te).getInputTank()));
        this.m_142416_((GuiEventListener)new WidgetTank(this.f_97735_ + 79, this.f_97736_ + 19, ((ThermopneumaticProcessingPlantBlockEntity)this.te).getOutputTank()));
        this.tempWidget = new WidgetTemperature(this.f_97735_ + 105, this.f_97736_ + 25, TemperatureRange.of(273, 673), 273, 50);
        this.m_142416_((GuiEventListener)this.tempWidget);
        this.dumpButton = new WidgetButtonExtended(this.f_97735_ + 14, this.f_97736_ + 86, 14, 14, (Component)Component.m_237119_()).withTag("dump");
        this.m_142416_((GuiEventListener)this.dumpButton);
        this.nExposedFaces = HeatUtil.countExposedFaces(Collections.singletonList((ThermopneumaticProcessingPlantBlockEntity)this.te));
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (((ThermopneumaticProcessingPlantBlockEntity)this.te).maxTemperature > ((ThermopneumaticProcessingPlantBlockEntity)this.te).minTemperature && !((ThermopneumaticProcessingPlantBlockEntity)this.te).getCurrentRecipeIdSynced().isEmpty()) {
            this.tempWidget.setOperatingRange(TemperatureRange.of(((ThermopneumaticProcessingPlantBlockEntity)this.te).minTemperature, ((ThermopneumaticProcessingPlantBlockEntity)this.te).maxTemperature));
        } else {
            this.tempWidget.setOperatingRange(null);
        }
        this.tempWidget.setTemperature(((ThermopneumaticProcessingPlantBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt());
        this.tempWidget.autoScaleForTemperature();
        if (ThermopneumaticProcessingPlantScreen.m_96638_()) {
            this.dumpButton.m_93666_((Component)Component.m_237113_((String)"X").m_130940_(ChatFormatting.RED));
            this.dumpButton.setTooltipKey("pneumaticcraft.gui.thermopneumatic.dumpInput", new Object[0]);
        } else {
            this.dumpButton.m_93666_((Component)Component.m_237113_((String)"\u25b6").m_130940_(ChatFormatting.DARK_AQUA));
            this.dumpButton.setTooltipKey("pneumaticcraft.gui.thermopneumatic.moveInput", new Object[0]);
        }
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        super.m_7286_(matrixStack, partialTicks, x, y);
        double progress = ((ThermopneumaticProcessingPlantBlockEntity)this.te).getCraftingPercentage();
        int progressWidth = (int)(progress * 48.0);
        this.bindGuiTexture();
        this.m_93228_(matrixStack, this.f_97735_ + 30, this.f_97736_ + 36, this.f_97726_, 0, progressWidth, 30);
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.95f, 1.0f, 1.0f);
        this.f_96547_.m_92877_(matrixStack, this.f_96539_.m_7532_(), (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.1f, 5.0f, 0x404040);
        matrixStack.m_85849_();
        super.m_7027_(matrixStack, x, y);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        return new PointXY(xStart + this.f_97726_ * 3 / 4 + 14, yStart + this.f_97727_ / 4 - 2);
    }

    @Override
    public void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((ThermopneumaticProcessingPlantBlockEntity)this.te).problem != null && ((ThermopneumaticProcessingPlantBlockEntity)this.te).problem != ThermopneumaticProcessingPlantBlockEntity.TPProblem.OK) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((ThermopneumaticProcessingPlantBlockEntity)this.te).problem.getTranslationKey(), new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (this.nExposedFaces > 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.exposedFaces", this.nExposedFaces, 6));
        }
    }

    @Override
    public Collection<ItemStack> getTargetItems() {
        return this.getCurrentRecipe((PneumaticCraftRecipeType)ModRecipeTypes.THERMO_PLANT.get()).map(thermoPlantRecipe -> Collections.singletonList(thermoPlantRecipe.getOutputItem())).orElse(Collections.emptyList());
    }

    @Override
    public Collection<FluidStack> getTargetFluids() {
        return this.getCurrentRecipe((PneumaticCraftRecipeType)ModRecipeTypes.THERMO_PLANT.get()).map(thermoPlantRecipe -> Collections.singletonList(thermoPlantRecipe.getOutputFluid())).orElse(Collections.emptyList());
    }
}

