/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.network;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import tcintegrations.network.BotaniaSetData;
import tcintegrations.network.IData;
import tcintegrations.network.LaunchGhostSword;
import tcintegrations.util.ResourceLocationHelper;

public final class NetworkHandler {
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocationHelper.resource("main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        int id = 0;
        if (ModList.get().isLoaded("botania")) {
            NetworkHandler.registerMessage(id++, BotaniaSetData.class, BotaniaSetData::new);
        }
        if (ModList.get().isLoaded("iceandfire")) {
            NetworkHandler.registerMessage(id++, LaunchGhostSword.class, LaunchGhostSword::new);
        }
    }

    private static <T extends IData> void registerMessage(int idx, Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.registerMessage(idx, type, IData::toBytes, decoder, (msg, ctx) -> {
            msg.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }
}

