/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data.tcon;

import java.util.Locale;
import net.minecraft.world.item.Item;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.smeltery.data.Byproduct;
import tcintegrations.data.tcon.material.MaterialIds;
import tcintegrations.items.TCIntegrationsItems;

public enum SmelteryCompat {
    MANASTEEL((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_MANASTEEL, "botania", Byproduct.IRON, Byproduct.GOLD),
    NEPTUNIUM((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_NEPTUNIUM, "aquaculture", new Byproduct[0]),
    SOUL_STAINED_STEEL((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL, "malum", new Byproduct[0]),
    CLOGGRUM((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_CLOGGRUM, "undergarden", new Byproduct[0]),
    FROSTSTEEL((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_FROSTSTEEL, "undergarden", new Byproduct[0]),
    FORGOTTEN((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_FORGOTTEN, "undergarden", new Byproduct[0]),
    PENDORITE_ALLOY((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY, "byg", new Byproduct[0]),
    DESH((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_DESH, MaterialIds.desh.m_135815_(), new Byproduct[0]),
    CALORITE((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_CALORITE, MaterialIds.calorite.m_135815_(), new Byproduct[0]),
    OSTRUM((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_OSTRUM, MaterialIds.ostrum.m_135815_(), new Byproduct[0]),
    DRAGONSTEEL_FIRE((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_FIRE, "iceandfire", Byproduct.IRON, Byproduct.GOLD),
    DRAGONSTEEL_ICE((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_ICE, "iceandfire", Byproduct.IRON, Byproduct.GOLD),
    DRAGONSTEEL_LIGHTNING((FluidObject<? extends ForgeFlowingFluid>)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_LIGHTNING, "iceandfire", Byproduct.IRON, Byproduct.GOLD);

    private final String name = this.name().toLowerCase(Locale.US);
    private final FluidObject<? extends ForgeFlowingFluid> fluid;
    private final boolean isOre;
    private final boolean hasDust;
    private final Byproduct[] byproducts;
    private final String identifier;

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, String identifier, boolean hasDust) {
        this.fluid = fluid;
        this.isOre = false;
        this.byproducts = new Byproduct[0];
        this.hasDust = hasDust;
        this.identifier = identifier;
    }

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, String identifier, Byproduct ... byproducts) {
        this.fluid = fluid;
        this.isOre = byproducts.length > 0;
        this.byproducts = byproducts;
        this.hasDust = true;
        this.identifier = identifier;
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public Item getBucket() {
        return this.fluid.m_5456_();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOre() {
        return this.isOre;
    }

    public boolean hasDust() {
        return this.hasDust;
    }

    public Byproduct[] getByproducts() {
        return this.byproducts;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

