/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.init.registrate.neapolitan;

import com.teamabnormals.neapolitan.common.block.FlavoredCandleCakeBlock;
import dev.xkmc.l2library.repack.registrate.builders.BlockBuilder;
import dev.xkmc.l2library.repack.registrate.providers.DataGenContext;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.l2library.repack.registrate.util.entry.BlockEntry;
import dev.xkmc.l2library.repack.registrate.util.entry.ItemEntry;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.twilightdelight.compat.neapolitan.TDCakeBlock;
import dev.xkmc.twilightdelight.content.item.food.TDFoodItem;
import dev.xkmc.twilightdelight.init.TwilightDelight;
import dev.xkmc.twilightdelight.init.registrate.TDEffects;
import dev.xkmc.twilightdelight.init.registrate.TDItems;
import dev.xkmc.twilightdelight.init.registrate.delight.DelightFoodType;
import dev.xkmc.twilightdelight.init.registrate.delight.EffectSupplier;
import dev.xkmc.twilightdelight.init.registrate.delight.IFoodType;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public enum NeapolitanCakes {
    AURORA(MaterialColor.f_76421_, new EffectSupplier((Supplier<MobEffect>)TDEffects.AURORA_GLOWING, 300, 0, 1.0f), new EffectSupplier(() -> MobEffects.f_19596_, 300, 2, 1.0f), new EffectSupplier(() -> MobEffects.f_19603_, 300, 1, 1.0f)),
    TORCHBERRY(MaterialColor.f_76416_, new EffectSupplier((Supplier<MobEffect>)TDEffects.FIRE_RANGE, 300, 0, 1.0f)),
    PHYTOCHEMICAL(MaterialColor.f_76363_, new EffectSupplier((Supplier<MobEffect>)TDEffects.POISON_RANGE, 300, 0, 1.0f)),
    GLACIER(MaterialColor.f_76415_, new EffectSupplier((Supplier<MobEffect>)TDEffects.FROZEN_RANGE, 300, 0, 1.0f));

    private final String base = this.name().toLowerCase(Locale.ROOT);
    public final BlockEntry<TDCakeBlock> block;
    public final BlockEntry<FlavoredCandleCakeBlock> candle;
    public final BlockEntry<FlavoredCandleCakeBlock>[] colored_candles;
    public final ItemEntry<TDFoodItem> item;

    private NeapolitanCakes(MaterialColor color, EffectSupplier ... effects) {
        FoodProperties food = TDItems.simpleFood((IFoodType)DelightFoodType.NONE, 1, 0.1f, effects);
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60944_((Material)Material.f_76287_, (MaterialColor)color).m_60978_(0.5f).m_60918_(SoundType.f_56745_);
        this.item = TwilightDelight.REGISTRATE.item(this.base + "_cake_slice", p -> new TDFoodItem(p.m_41489_(food))).defaultModel().defaultLang().register();
        this.block = ((BlockBuilder)TwilightDelight.REGISTRATE.block(this.base + "_cake", p -> new TDCakeBlock(food, props, this)).blockstate(this::genCakeModels).loot((pvd, block) -> pvd.m_124147_((Block)block, (ItemLike)this.item.get())).item().model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx)).build()).register();
        this.candle = TwilightDelight.REGISTRATE.block(this.base + "_candle_cake", p -> new FlavoredCandleCakeBlock(() -> this.block.get(), Blocks.f_152482_, props)).blockstate((ctx, pvd) -> this.genCandleModels((DataGenContext<Block, FlavoredCandleCakeBlock>)ctx, (RegistrateBlockstateProvider)pvd, "candle")).loot((pvd, block) -> pvd.m_124147_((Block)block, (ItemLike)Items.f_151065_)).tag(new TagKey[]{BlockTags.f_144268_}).register();
        this.colored_candles = new BlockEntry[DyeColor.values().length];
        for (DyeColor dye : DyeColor.values()) {
            String color_name = dye.m_41065_();
            Block candle = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(color_name + "_candle"));
            this.colored_candles[dye.ordinal()] = TwilightDelight.REGISTRATE.block(color_name + "_" + this.base + "_candle_cake", p -> new FlavoredCandleCakeBlock(() -> this.block.get(), candle, props)).blockstate((ctx, pvd) -> this.genCandleModels((DataGenContext<Block, FlavoredCandleCakeBlock>)ctx, (RegistrateBlockstateProvider)pvd, color_name + "_candle")).loot((pvd, block) -> pvd.m_124147_((Block)block, (ItemLike)candle.m_5456_())).tag(new TagKey[]{BlockTags.f_144268_}).register();
        }
    }

    private void genCandleModels(DataGenContext<Block, FlavoredCandleCakeBlock> ctx, RegistrateBlockstateProvider pvd, String candle) {
        BlockModelBuilder nolit = this.genCandleCakeModel(ctx, pvd, candle, false);
        BlockModelBuilder lit = this.genCandleCakeModel(ctx, pvd, candle, true);
        pvd.getVariantBuilder((Block)ctx.getEntry()).forAllStates(e -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)e.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lit : nolit)).build());
    }

    private void genCakeModels(DataGenContext<Block, TDCakeBlock> ctx, RegistrateBlockstateProvider pvd) {
        BlockModelBuilder[] slice = new BlockModelBuilder[7];
        slice[0] = this.genCakeModel(pvd, "cake");
        for (int i = 1; i <= 6; ++i) {
            slice[i] = this.genCakeModel(pvd, "cake_slice" + i);
        }
        pvd.getVariantBuilder((Block)ctx.getEntry()).forAllStates(e -> ConfiguredModel.builder().modelFile((ModelFile)slice[(Integer)e.m_61143_((Property)BlockStateProperties.f_61412_)]).build());
    }

    private BlockModelBuilder genCakeModel(RegistrateBlockstateProvider pvd, String model) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(this.base + "_" + model, new ResourceLocation("block/" + model))).texture("particle", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("bottom", pvd.modLoc("block/" + this.base + "_cake_bottom"))).texture("top", pvd.modLoc("block/" + this.base + "_cake_top"))).texture("side", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("inside", pvd.modLoc("block/" + this.base + "_cake_inner"));
    }

    private BlockModelBuilder genCandleCakeModel(DataGenContext<Block, FlavoredCandleCakeBlock> ctx, RegistrateBlockstateProvider pvd, String candle, boolean lit) {
        Object name = ctx.getName();
        if (lit) {
            name = (String)name + "_lit";
            candle = (String)candle + "_lit";
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent((String)name, new ResourceLocation("block/template_cake_with_candle"))).texture("particle", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("bottom", pvd.modLoc("block/" + this.base + "_cake_bottom"))).texture("top", pvd.modLoc("block/" + this.base + "_cake_top"))).texture("side", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("candle", pvd.mcLoc("block/" + (String)candle));
    }

    public static void register() {
    }
}

